proc ExpandLine {string} {
  regsub -all {\$\\sim\$} $string "~" string
  regsub -all {\$\|\$} $string "|" string
  regsub -all {\$<\$} $string "<" string
  regsub -all {\$>\$} $string ">" string
  regsub -all "\\\\ref{.*}" $string "" string
  regsub -all "\\\\pageref{.*}" $string "" string
  regsub -all "\\\\cite{.*}" $string "" string
  regsub -all "\\\\index{.*}" $string "" string
  regsub -all "{\\\\em " $string "" string
  regsub -all "\\\\em}" $string "" string
  regsub -all "{\\\\tt " $string "" string
  regsub -all "\\\\tt}" $string "" string
  regsub -all {\\#} $string "#" string
  regsub -all {\\-} $string "" string
  regsub -all {\\_} $string "_" string
  regsub -all {\\&} $string "&" string
  regsub -all {\\TCLTKS} $string "Tcl/Tk" string
  regsub -all {\\TCLTK} $string "Tcl/Tk" string
  regsub -all {\\TCLS} $string "Tcl" string
  regsub -all {\\TCL} $string "Tcl" string
  regsub -all {\\TKS} $string "Tk" string
  regsub -all {\\TK} $string "Tk" string
  regsub -all {\\XFS} $string "XF" string
  regsub -all {\\XF} $string "XF" string
  regsub -all {\\MOTIFS} $string "Motif(tm)" string
  regsub -all {\\MOTIF} $string "Motif(tm)" string
  return $string
}

proc FormatString {string} {
  set skip 0
  set lineLength 60
  set line ""
  set result ""
  if {"[string trim $string]" == ""} {
    return ""
  }
  foreach counter $string {
    if {"$counter" == "%%%XFNewLine"} {
      if {"$line" != ""} {
        append result "$line\n\n"
      } {
        if {"$result" != ""} {
          append result "$line\n"
        }
      }
      set line ""
      continue
    }
    if {"$counter" == "%%%XFStartIgnore"} {
      set skip 1
      continue
    }
    if {"$counter" == "%%%XFEndIgnore"} {
      set skip 0
      continue
    }
    if {$skip} {
      append result "$counter "
      continue
    }
    if {!([expr [string length $line]+[string length $counter]] > $lineLength) ||
        [llength $line] == 0} {
      append line "$counter "
    } {
      append result "$line\n"
      set line "$counter "
    }
  }
  if {"$line" != ""} {
    append result "$line\n"
  }
  regsub -all {%%%XFNewLine} $result [format \n] result
  regsub -all {%%%XFSpace} $result { } result
  return $result
}

proc MakeTable {string} {
  global tableString

  regsub -all {&} $string " " string
  regsub -all {\\hline} $string "" string
  regsub -all {\\} $string "" string
  regsub -all { } $string "%%%XFSpace" string
  append tableString "$string %%%XFNewLine\n"
}

proc ConvertFile {inFile} {
  global outPrefix
  global tableString

  set skip 0
  set inTable 0
  set outFile ""
  set appendFile ""
  set outString ""
  set tableString ""
  set inFd [open $inFile r]
  puts stdout "Converting: $inFile"
  while {1} {
    if {[gets $inFd fileLine] == -1} {
      break
    }
    if {[string match "%%%XFStartFile *" $fileLine]} {
      set outFile [string range $fileLine 15 [string length $fileLine]]
      set appendFile ""
      continue
    }
    if {[string match "%%%XFCurrentFile *" $fileLine]} {
      set outFile ""
      set appendFile [string range $fileLine 17 [string length $fileLine]]
      continue
    }
    if {[string match "%%%XFEndFil*" $fileLine]} {
      if {"$outFile" != ""} {
        # write file
        set outFd [open $outPrefix/$outFile w]
        puts $outFd [FormatString $outString]
        close $outFd
      }
      if {"$appendFile" != ""} {
        # write file
        set outFd [open $outPrefix/$appendFile a]
        puts $outFd [FormatString $outString]
        close $outFd
      }
      set outFile ""
      set appendFile ""
      set outString ""
      continue
    }
    if {[string match "%%%XFShowPS *" $fileLine]} {
      if {"$outFile" != ""} {
        set psFile "[string range $fileLine 12 [string length $fileLine]]"
        if {[catch "exec cp $psFile $outPrefix/[file dirname $outFile]/[file tail $psFile]" result] != 0} {
          puts stderr $result
        }
        set outFd [open $outPrefix/[file dirname $outFile]/[file rootname [file tail $outFile]].S w]
        puts $outFd "DisplayPostscript \$runPath/[file tail $psFile]"
        close $outFd
      }
      if {"$appendFile" != ""} {
        set psFile "[string range $fileLine 12 [string length $fileLine]]"
        if {[catch "exec cp $psFile $outPrefix/[file dirname $appendFile]/[file tail $psFile]" result] != 0} {
          puts stderr $result
        }
        set outFd [open $outPrefix/[file dirname $appendFile]/[file rootname [file tail $appendFile]].S w]
        puts $outFd "DisplayPostscript \$runPath/[file tail $psFile]"
        close $outFd
      }
      continue
    }
    if {[string match "%%%XFPrint *" $fileLine]} {
      if {"$outFile" != "" || "$appendFile" != ""} {
        if {$inTable} {
          MakeTable [ExpandLine [string range $fileLine 11 [string length $fileLine]]]
        } {
          append outString "%%%XFStartIgnore\n"
          append outString "[string range $fileLine 11 [string length $fileLine]]\n"
          append outString "%%%XFNewLine\n"
          append outString "%%%XFEndIgnore\n"
        }
      }
      continue
    }
    if {[string match "%%%XFStartTabl*" $fileLine]} {
      set inTable 1
      set tableString ""
      continue
    }
    if {[string match "%%%XFEndTabl*" $fileLine]} {
      set inTable 0
      append outString "%%%XFStartIgnore\n"
      append outString "$tableString\n"
      append outString "%%%XFEndIgnore\n"
      continue
    }
    if {[string match "%%%XFStartIgnor*" $fileLine]} {
      set skip 1
      continue
    }
    if {[string match "%%%XFEndIgnor*" $fileLine]} {
      set skip 0
      continue
    }
    if {[string match {\\clearpag*} $fileLine] ||
        [string match {\\myclearpag*} $fileLine] ||
        [string match {\\begin{supertabular}*} $fileLine] ||
        [string match {\\begin{tabular}*} $fileLine] ||
        [string match {\\end{tabular}*} $fileLine] ||
        [string match {\\end{supertabular}*} $fileLine] ||
        [string match {\\bigski*} $fileLine]} {
      continue
    }
    if {$skip} {
      continue
    }
    if {$inTable} {
      MakeTable [ExpandLine $fileLine]
    } {
      if {"[string trim $fileLine]" == ""} {
        append outString "%%%XFNewLine "
        continue
      }
      # convert contents
      if {"$outFile" != "" || "$appendFile" != ""} {
        append outString "[string trim [ExpandLine $fileLine]]\n"
      }
    }
  }
  close $inFd
}

# initialise
set outPrefix "./xf-doc/xfhelp"
if {$argc == 2} {
  set outPrefix [lindex $argv 0]
}


# convert dialog.tex
if {[catch "exec mkdir $outPrefix" result] != 0} {
  puts stderr $result
}
catch "exec mkdir $outPrefix/Configuration"
catch "exec mkdir $outPrefix/Edit"
catch "exec mkdir $outPrefix/File"
catch "exec mkdir $outPrefix/Help"
catch "exec mkdir $outPrefix/Misc"
catch "exec mkdir $outPrefix/Options"
catch "exec mkdir $outPrefix/Programming"

foreach inFile {./dialog/Config.tex ./dialog/Edit.tex ./dialog/File.tex ./dialog/Help.tex ./dialog/Misc.tex ./dialog/Options.tex ./dialog/Prog.tex} {
  ConvertFile $inFile
}


# convert external.tex
catch "exec mkdir $outPrefix/xfappdef"
catch "exec mkdir $outPrefix/xfhardcopy"
catch "exec mkdir $outPrefix/xfhelp"
catch "exec mkdir $outPrefix/xfpixmap"
catch "exec mkdir $outPrefix/xftutorial"

foreach inFile {./external/appdef.tex ./external/hardcopy.tex ./external/help.tex ./external/pixmap.tex ./external/tutorial.tex} {
  ConvertFile $inFile
}

# convert templates.tex
catch "exec mkdir $outPrefix/Tmplt-Combined"
catch "exec mkdir $outPrefix/Tmplt-Procedures"
catch "exec mkdir $outPrefix/Tmplt-Widgets"

foreach inFile {./templates/CanvasLS.tex ./templates/EntryL.tex ./templates/HypertextLS.tex ./templates/ListboxLS.tex ./templates/PhotoLS.tex ./templates/TextLS.tex ./templates/TkEmacs.tex} {
  ConvertFile $inFile
}

foreach inFile {./templates/AlertBox.tex ./templates/ClearList.tex ./templates/ColorBox.tex ./templates/CursorBox.tex ./templates/FSBox.tex ./templates/FdInList.tex ./templates/FontBox.tex ./templates/IconBar.tex ./templates/InputBox.tex ./templates/IsADir.tex ./templates/KeysymBox.tex ./templates/MakeMButton.tex ./templates/MenuBar.tex ./templates/ReadBox.tex ./templates/TextBox.tex ./templates/YesNoBox.tex ./templates/fileselect.tex} {
  ConvertFile $inFile
}

foreach inFile {./templates/MListbox.tex ./templates/Menubar.tex ./templates/OptionButtonE.tex ./templates/Popup.tex} {
  ConvertFile $inFile
}

# convert using.tex
set outPrefix "./xf-doc/xftutorial/script.xf"
if {$argc == 2} {
  set outPrefix [lindex $argv 1]
}

catch "exec mkdir $outPrefix/"

foreach inFile {./using.tex ./using/Start.tex ./using/Inserting.tex ./using/Layouting.tex ./using/Configuring.tex ./using/Procedures.tex ./using/Templates.tex ./using/Toplevels.tex ./using/Modules.tex ./using/Levels.tex} {
  ConvertFile $inFile
}

exit
