/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.tabbedpane;

import com.vldocking.swing.tabbedpane.SmartIconJButton;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class JTabbedPaneSmartIcon
implements Icon,
Cloneable {
    private Icon icon;
    private int width;
    private int otherIconsOffset;
    private int height;
    private String label;
    private String tooltipText;
    private String localTooltipText;
    private SmartIconJButton[] otherIcons;
    private SmartIconJButton pressedButton;
    private SmartIconJButton rolloverButton;
    private int textIconGap;
    private int otherIconsGap;
    private boolean antialiased = false;
    private JTabbedPane container;
    private int inBetweenOtherIconsGap;

    public JTabbedPaneSmartIcon(Icon icon, String label, SmartIconJButton[] otherIcons) {
        this.icon = icon;
        this.label = label;
        this.otherIcons = otherIcons;
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.otherIconsGap = UIManager.getInt("TabbedPane.otherIconsGap");
        this.inBetweenOtherIconsGap = UIManager.getInt("TabbedPane.inBetweenOtherIconsGap");
        this.invalidateSize();
        try {
            this.antialiased = "true".equals(System.getProperty("swing.aatext"));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
    }

    public SmartIconJButton getSmartButton(int index) {
        return this.otherIcons[index];
    }

    public void setSmartButton(int index, SmartIconJButton btn) {
        this.otherIcons[index] = btn;
        this.invalidateSize();
    }

    public JTabbedPaneSmartIcon copy() {
        return (JTabbedPaneSmartIcon)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignore) {
            ignore.printStackTrace();
            return null;
        }
    }

    public void setTooltipText(String tooltip) {
        this.tooltipText = tooltip;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public String getLocalTooltipText() {
        return this.localTooltipText;
    }

    public void setLabel(String label) {
        this.label = label;
        this.invalidateSize();
    }

    public String getLabel() {
        return this.label;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.invalidateSize();
    }

    public Icon getIcon() {
        return this.icon;
    }

    private void invalidateSize() {
        this.height = -1;
        this.width = -1;
    }

    public void setIconForTabbedPane(JTabbedPane container) {
        this.container = container;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Font f;
        Graphics2D g2 = (Graphics2D)g;
        Object renderingValue = null;
        if (this.antialiased) {
            renderingValue = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.icon != null) {
            this.icon.paintIcon(c, g, x, y);
        }
        if ((f = UIManager.getFont("JTabbedPaneSmartIcon.font")) != null) {
            g.setFont(f);
        }
        FontMetrics fm = g.getFontMetrics();
        int iconsOffset = this.otherIconsOffset;
        if (this.icon != null) {
            g.drawString(this.label, x + this.icon.getIconWidth() + this.textIconGap, y + this.height - fm.getDescent());
        } else {
            g.drawString(this.label, x, y + this.height - fm.getDescent());
        }
        if (this.otherIcons != null) {
            for (int i = 0; i < this.otherIcons.length; ++i) {
                this.otherIcons[i].paintIcon(c, g, x + iconsOffset, y + this.height / 2 - this.otherIcons[i].getIconHeight() / 2);
                iconsOffset += this.otherIcons[i].getIconWidth();
                if (i >= this.otherIcons.length - 1) continue;
                iconsOffset += this.inBetweenOtherIconsGap;
            }
        }
        if (this.antialiased) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingValue);
        }
    }

    private SmartIconJButton findButtonAt(Point p) {
        int start = this.otherIconsOffset;
        if (this.otherIcons != null) {
            for (int i = 0; i < this.otherIcons.length; ++i) {
                SmartIconJButton btn = this.otherIcons[i];
                if (p.x >= start && p.x < start + btn.getIconWidth()) {
                    if (p.y >= this.height / 2 - btn.getIconHeight() / 2 && p.y < this.height / 2 + btn.getIconHeight() / 2) {
                        return btn;
                    }
                    return null;
                }
                start += btn.getIconWidth();
                if (i >= this.otherIcons.length - 1) continue;
                start += this.inBetweenOtherIconsGap;
            }
        }
        return null;
    }

    @Override
    public int getIconWidth() {
        if (this.width == -1) {
            if (this.container == null) {
                throw new NullPointerException("container for this smart icon not specified with setIconForTabbedPane()");
            }
            Font f = UIManager.getFont("JTabbedPaneSmartIcon.font");
            FontMetrics fm = this.container.getFontMetrics(f);
            this.width = 0;
            if (this.icon != null) {
                this.width = this.icon.getIconWidth();
            }
            this.width += this.textIconGap + fm.stringWidth(this.label) + this.otherIconsGap;
            int iconsOffset = this.otherIconsOffset = this.width;
            if (this.otherIcons != null) {
                for (int i = 0; i < this.otherIcons.length; ++i) {
                    this.width += this.otherIcons[i].getIconWidth();
                    if (i >= this.otherIcons.length - 1) continue;
                    this.width += this.inBetweenOtherIconsGap;
                }
            }
        }
        return this.width;
    }

    @Override
    public int getIconHeight() {
        if (this.height == -1) {
            this.height = this.icon != null ? this.icon.getIconHeight() : 16;
        }
        return this.height;
    }

    public boolean onMousePressed(MouseEvent e) {
        SmartIconJButton btn = this.findButtonAt(e.getPoint());
        if (btn != null && btn.isEnabled()) {
            btn.setPressed(true);
            this.pressedButton = btn;
            return true;
        }
        return false;
    }

    public boolean onMouseReleased(MouseEvent e) {
        if (this.pressedButton != null && this.pressedButton.isEnabled()) {
            this.pressedButton.setPressed(false);
            SmartIconJButton btn = this.findButtonAt(e.getPoint());
            if (btn == this.pressedButton) {
                btn.fireAction(new ActionEvent(e.getSource(), 1001, ""));
                return true;
            }
        }
        return false;
    }

    public boolean onMouseExited(MouseEvent e) {
        if (this.rolloverButton != null) {
            this.rolloverButton.setRollover(false);
            this.rolloverButton = null;
            this.localTooltipText = this.tooltipText;
            return true;
        }
        this.rolloverButton = null;
        return false;
    }

    public boolean onMouseMoved(MouseEvent e) {
        SmartIconJButton btn = this.findButtonAt(e.getPoint());
        boolean shouldRepaint = false;
        if (btn != null) {
            String tip = btn.getTooltipText();
            if (tip != null) {
                if (!tip.equals(this.localTooltipText)) {
                    this.localTooltipText = tip;
                    shouldRepaint = true;
                }
            } else if (this.localTooltipText != this.tooltipText) {
                this.localTooltipText = this.tooltipText;
                shouldRepaint = true;
            }
            if (btn != this.rolloverButton) {
                if (this.rolloverButton != null) {
                    this.rolloverButton.setRollover(false);
                }
                this.rolloverButton = btn;
                this.rolloverButton.setRollover(true);
                shouldRepaint = true;
            }
        } else if (this.rolloverButton != null) {
            this.rolloverButton.setRollover(false);
            this.rolloverButton = null;
            this.localTooltipText = this.tooltipText;
            shouldRepaint = true;
        }
        return shouldRepaint;
    }
}

