// Key.cpp
// David Aylesworth

#include "stdafx.h"
#include "ctype.h"
#include "string.h"
extern "C"
{
#include "OPIE/opie_cfg.h"
#include "OPIE/opie.h"
}
#include "Key.h"


BOOL KeyParseChallenge(CString &challenge, int &algorithm, int &sequence, CString &seed)
{
	CString newchallenge;

    char *s = challenge.GetBuffer(0);
	if (s == NULL || *s == '\0')
        return FALSE;

	// make sure challenge is not multiline
	char *t;
	if ((t = strchr(s, '\n')) != NULL && t[1] != '\0') {
		challenge.ReleaseBuffer();
		return FALSE;
	}

    // parse algorithm      
    t = strtok(s, " ");
	if (t == NULL) {
		challenge.ReleaseBuffer();
		return FALSE;
	}
	do {
		if (strstr(t, "md4") || strstr(t, "MD4")) {
		    algorithm = 4;
			newchallenge += t;
			newchallenge += " ";
		    t = strtok(NULL, " ");
			break;
		}
		else if (strstr(t, "md5") || strstr(t, "MD5")) {
		    algorithm = 5;
			newchallenge += t;
			newchallenge += " ";
		    t = strtok(NULL, " ");
			break;
		}
		else if (atoi(t) > 0) {
		    algorithm = -1;
			break;
		}
	} while (t = strtok(NULL, " "));

	// parse sequence number
    if (t == NULL) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
	s = t;
	while (*s) {
		if (!isdigit(*s)) {
			challenge.ReleaseBuffer();
			return FALSE;
		}
		s++;
	}
    sequence = atoi(t);
    if (sequence < 1) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
	newchallenge += t;
	newchallenge += " ";
		
    // parse seed
	t = strtok(NULL, " \t\r\n");
	if (t == NULL || !isalnum(*t)) {
		challenge.ReleaseBuffer();
		return FALSE;
	}
	s = t;
	while (isalnum(*s))
		s++;
	*s = '\0';
    seed = t;
	newchallenge += t;

    challenge.ReleaseBuffer();
	challenge = newchallenge;

    return TRUE;
}


BOOL KeyGenerateResponse(int algorithm, int keynum, CString &seed, CString &password, CString &response)
{
    /* Crunch seed and secret password into starting key normally */
    char key[8];   
    if (opiekeycrunch((unsigned)algorithm, key, (char *)(const char *)seed,
                      (char *)(const char *)password) != 0)
        return FALSE;

    while (keynum-- != 0)
        opiehash(key, algorithm);

    char buf[33];
    response = opiebtoe(buf, key);

    return TRUE;
}
