// Key.cpp
// David Aylesworth

#include "stdafx.h"
#include "ctype.h"
#include "string.h"
extern "C"
{
#include "OPIE/opie_cfg.h"
#include "OPIE/opie.h"
}
#include "Key.h"


BOOL KeyParseChallenge(CString &challenge, int &algorithm, int &sequence, CString &seed)
{
	CString newchallenge;

    wint_t *s = challenge.GetBuffer(0);
	if (s == NULL || *s == '\0')
        return FALSE;

	// make sure challenge is not multiline
	TCHAR *t;
	if ((t = _tcschr(s, _T('\n'))) != NULL && t[1] != '\0') {
		challenge.ReleaseBuffer();
		return FALSE;
	}

    // parse algorithm      
    t = _tcstok(s, _T(" "));
	if (t == NULL) {
		challenge.ReleaseBuffer();
		return FALSE;
	}
	do {
		if (_tcsstr(t, _T("md4")) || _tcsstr(t, _T("MD4"))) {
		    algorithm = 4;
			newchallenge += t;
			newchallenge += " ";
		    t = _tcstok(NULL, _T(" "));
			break;
		}
		else if (_tcsstr(t, _T("md5")) || _tcsstr(t, _T("MD5"))) {
		    algorithm = 5;
			newchallenge += t;
			newchallenge += " ";
		    t = _tcstok(NULL, _T(" "));
			break;
		}
		else if (_wtoi(t) > 0) {
		    algorithm = -1;
			break;
		}
	} while (t = _tcstok(NULL, _T(" ")));

	// parse sequence number
    if (t == NULL) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
	s = t;
	while (*s) {
		if (!_istdigit(*s)) {
			challenge.ReleaseBuffer();
			return FALSE;
		}
		s++;
	}
    sequence = _wtoi(t);
    if (sequence < 1) {
        challenge.ReleaseBuffer();
        return FALSE;
    }
	newchallenge += t;
	newchallenge += " ";
		
    // parse seed
	t = _tcstok(NULL, _T(" \t\r\n"));
	if (t == NULL || !_istalnum(*t)) {
		challenge.ReleaseBuffer();
		return FALSE;
	}
	s = t;
	while (_istalnum(*s))
		s++;
	*s = '\0';
    seed = t;
	newchallenge += t;

    challenge.ReleaseBuffer();
	challenge = newchallenge;

    return TRUE;
}


BOOL KeyGenerateResponse(int algorithm, int keynum, CString &seed, CString &password, CString &response)
{
    /* Crunch seed and secret password into starting key normally */
    // Modifications for CE Compatibility
	char key[8];   
	ULONG cbAnsiSeed, cCharactersSeed, cbAnsiPassword, cCharactersPassword;
	LPSTR* ppszASeed;
	LPSTR* ppszAPassword;

	cCharactersSeed = wcslen((LPCTSTR)seed)+1;
	cCharactersPassword = wcslen((LPCTSTR)password)+1;
    // Determine number of bytes to be allocated for ANSI string. An
    // ANSI string can have at most 2 bytes per character (for Double
    // Byte Character Strings.)
    cbAnsiSeed = cCharactersSeed*2;
	cbAnsiPassword = cCharactersPassword*2;

    // Use of the OLE allocator is not required because the resultant
    // ANSI  string will never be passed to another COM component. You
    // can use your own allocator.
    *ppszASeed = (LPSTR) CoTaskMemAlloc(cbAnsiSeed);
	*ppszAPassword = (LPSTR) CoTaskMemAlloc(cbAnsiPassword);
    if (NULL == *ppszASeed)
        return E_OUTOFMEMORY;
	if (NULL == *ppszAPassword)
        return E_OUTOFMEMORY;

	WideCharToMultiByte(CP_ACP, 0, (LPCTSTR)seed, cCharactersSeed, *ppszASeed,
                  cbAnsiSeed, NULL, NULL);


    WideCharToMultiByte(CP_ACP, 0, (LPCTSTR)password, cCharactersPassword, *ppszAPassword,
                  cbAnsiPassword, NULL, NULL);
    

    if (opiekeycrunch((unsigned)algorithm, key, *ppszASeed,
                      *ppszAPassword) != 0)
        return FALSE;	
		/*
		char key[8];   
		if (opiekeycrunch((unsigned)algorithm, key, (char *)(const char *)seed,
						  (char *)(const char *)password) != 0)
			return FALSE;
		*/

    while (keynum-- != 0)
        opiehash(key, algorithm);

    char buf[33];
    response = opiebtoe(buf, key);

    return TRUE;
}
