// KeyDlg.cpp
// David Aylesworth

#include "stdafx.h"
#include "WinKey.h"
#include "Key.h"
#include "KeyDlg.h"
#include "OptDlg.h"
#include "Help/WinKey.hh"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CKeyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg dialog

CKeyDlg::CKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKeyDlg)
	m_password_str = _T("");
	//}}AFX_DATA_INIT

	// load icon
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hSmallIcon = AfxGetApp()->LoadIcon(IDI_SMALLICON);

	// load user preferences
	m_autopaste = theApp.GetProfileInt(_T("Settings"), _T("AutoPaste"), 1);
	m_autocopy = theApp.GetProfileInt(_T("Settings"), _T("AutoCopy"), 1);
	m_autodecrement = theApp.GetProfileInt(_T("Settings"), _T("AutoDecrement"), 0);
	m_autoclear = theApp.GetProfileInt(_T("Settings"), _T("AutoClear"), 0);
	m_appendcrlf = theApp.GetProfileInt(_T("Settings"), _T("AppendCRLF"), 0);
	// Useless under Windows CE
#ifndef _WIN32_WCE
	m_cbviewer = theApp.GetProfileInt(_T("Settings"), _T("CBViewer"), 0);
#endif
	m_hide = theApp.GetProfileInt(_T("Settings"), _T("AutoMinimize"), 0);
	CString alg = theApp.GetProfileString(_T("Settings"), _T("Algorithm"), _T("MD5"));
	m_algorithm = (alg == _T("MD5"));
	m_taskbar = theApp.GetProfileInt(_T("Settings"), _T("TaskbarIcon"), 1);
	m_starthidden = theApp.GetProfileInt(_T("Settings"), _T("HideOnStartup"), 0);
	m_onetime = theApp.GetProfileInt(_T("Settings"), _T("AutoExit"), 0);
}

void CKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyDlg)
	DDX_Control(pDX, IDC_EDIT2, m_password);
	DDX_Control(pDX, IDC_EDIT3, m_response);
	DDX_Control(pDX, IDC_EDIT1, m_challenge);
	DDX_Text(pDX, IDC_EDIT2, m_password_str);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyDlg)
	ON_WM_SYSCOMMAND()
	ON_BN_CLICKED(ID_OPTIONS, OnOptions)
	ON_BN_CLICKED(IDOK, OnCompute)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_WM_MOVE()
	ON_WM_HELPINFO()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
	ON_WM_ACTIVATE()
	// Not available under Windows CE
	// Not able to monitor clipboard for challenge
#ifndef _WIN32_WCE
	ON_WM_DRAWCLIPBOARD()
	ON_WM_CHANGECBCHAIN()
#endif
	ON_MESSAGE(UWM_TASKTRAY, OnTaskTray)
	ON_COMMAND(IDM_DISPLAY, OnDisplay)
	ON_COMMAND(IDM_OPTIONS, OnOptions)
	ON_COMMAND(IDM_HELP, OnHelp)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_COMMAND(IDM_EXIT, OnExit)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyDlg message handlers

BOOL CKeyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	// Add "About..." menu item to system menu.
	
// GetSystemMenu does not exists under Windows CE, so all of this is useless
#ifndef _WIN32_WCE
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
#endif

	// set window position
	int x = theApp.GetProfileInt(_T("Location"), _T("Left"), 20);
	int y = theApp.GetProfileInt(_T("Location"), _T("Top"), 20);
	SetWindowPos(NULL, x, y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);

	// load last saved challenge
	if (!m_autopaste)
		m_challenge.SetWindowText(theApp.GetProfileString(_T("Defaults"), _T("Challenge"), _T("")));

	// load pop-up menu
	m_menu.LoadMenu(IDR_MENU);

	// add taskbar icon
	if (m_taskbar)
	{
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
		tnid.uCallbackMessage = UWM_TASKTRAY;
		tnid.hIcon = m_hIcon;
		// lstrcpyn is not supported under Windows CE
		_tcsncpy(tnid.szTip, _T("WinKey"), sizeof(tnid.szTip));	// Modified for Windows CE
		/*
			lstrcpyn(tnid.szTip, "WinKey", sizeof(tnid.szTip));
		*/
		m_taskbar = Shell_NotifyIcon(NIM_ADD, &tnid);
	}

	// become clipboard viewer
	m_viewer = 0;
	
// SetClipBoardViewer not supported under Windows CE
#ifndef _WIN32_WCE
	m_viewer = SetClipboardViewer();
#endif

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CKeyDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CKeyDlg::OnOptions() 
{
	COptionsDlg *dlg;
	dlg = new COptionsDlg(this);
	if (dlg)
		dlg->DoModal();
	delete dlg;
}

void CKeyDlg::OnCompute() 
{
    HCURSOR oldCursor = SetCursor(theApp.LoadStandardCursor(IDC_WAIT));
    UpdateData(TRUE);

    /* parse challenge */
    CString challenge;
    m_challenge.GetWindowText(challenge);
    int algorithm;
    int keynum;
    CString seed;
   
    if (!KeyParseChallenge(challenge, algorithm, keynum, seed)) {
	    m_response.SetWindowText(_T("invalid OTP challenge"));
        if (m_autoclear) {
            m_password_str.Empty();
            UpdateData(FALSE);
        }
        m_challenge.SetFocus();
        m_challenge.SetSel(0, -1, TRUE);
        SetCursor(oldCursor);
        return;
    }

	m_challenge.SetWindowText(challenge);

    if (algorithm == -1)
		algorithm = m_algorithm + 4;

	// generate response
    CString response, response2;
	if (!KeyGenerateResponse(algorithm, keynum, seed, m_password_str, response)) {
	    m_response.SetWindowText(_T("key crunch failed"));
        if (m_autoclear) {
            m_password_str.Empty();
            UpdateData(FALSE);
        }
        SetCursor(oldCursor);
        return;
    }
	response2 = response;

	// clear password field
    if (m_autoclear) {
        m_password_str.Empty();
        UpdateData(FALSE);
    }

	// decrement sequence #
    if (m_autodecrement && keynum>0) {
        char buf[64];      
        sprintf(buf, "%s %d %s", (algorithm == 4) ? "otp-md4" : "otp-md5",
                keynum-1, seed);
        challenge = buf;
        m_challenge.SetWindowText(challenge);
    }

	// save challenge
    theApp.WriteProfileString(_T("Defaults"), _T("Challenge"), challenge);

	// display response
    m_response.SetWindowText(response);
    m_response.SetFocus();
    m_response.SetSel(0, -1, TRUE);
    m_response.LineScroll(0);
    if (m_autocopy) {
        if (m_appendcrlf)
    	    response += "\r\n";
        if (OpenClipboard()) {
            EmptyClipboard();
// GlobalAlloc, GlobalLock & GlobalUnlock are not supported under Windows CE, 
// using LocalAlloc, LocalLock & LocalUnlock instead, 
// which the prefered methods for SetClipboardData
#ifdef _WIN32_WCE
			HANDLE handle = LocalAlloc(LMEM_FIXED,
                                        response.GetLength() + 1);		
            TCHAR *s = (TCHAR *)LocalLock(handle);						
            _tcscpy(s, response);										
            LocalUnlock(handle);										
#else
			HANDLE handle = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE,
										response.GetLength() + 1);
			TCHAR *s = (TCHAR *)GlobalLock(handle);
			_tcscpy(s, response);
			GlobalUnlock(handle);
#endif
			SetClipboardData(CF_TEXT, handle);
            CloseClipboard();
        }
    }

	// hide or minimize window
	if (m_hide) 
	{
		if (m_taskbar)
		{
			ShowWindow(SW_HIDE);
		}
// WINDOWPLACEMENT Structure not supported under Windows CE
#ifndef _WIN32_WCE
		else 
		{
			WINDOWPLACEMENT wndpl;
			GetWindowPlacement(&wndpl);
			wndpl.showCmd = SW_MINIMIZE;
			SetWindowPlacement(&wndpl);
		}
#endif
	}
	if (m_onetime)
	{
		DestroyWindow();
	}

#ifdef SESSION_AUTH
	// send session auth reply
	if (!theApp.m_fwchallenge.IsEmpty())
	{
		theApp.m_arOut->WriteString(response2);
		theApp.m_arOut->Write("\n", 1);
		theApp.m_arOut->Flush();
		theApp.m_fwchallenge.Empty();
	}
#endif

    SetCursor(oldCursor);
}

void CKeyDlg::OnActivate(UINT nState, CWnd *pWndOther, BOOL bMinimized)
{
    CWnd::OnActivate(nState, pWndOther, bMinimized);

    if (nState != WA_INACTIVE)
	{
        // set focus to challenge field
        m_challenge.SetFocus();
        m_challenge.SetSel(0, -1, TRUE);

		// paste clipboard text into challenge
        if (m_autopaste) {
            if (OpenClipboard()) {
                HANDLE handle = GetClipboardData(CF_TEXT);
                if (handle) {
					// GlobalLock & GlobalUnlock are not supported under Windows CE, 
					// using LocalLock & LocalUnlock instead, 
					// which the prefered methods for SetClipboardData
#ifdef _WIN32_WCE
					CString s = (char *)LocalLock(handle);
					LocalUnlock(handle);
#else
					CString s = (char *)GlobalLock(handle);
					GlobalUnlock(handle); 
#endif
                    CloseClipboard();
                    int algorithm, sequence;
                    CString seed;
                    if (KeyParseChallenge(s, algorithm, sequence, seed)) {
						m_challenge.SetWindowText(s);
                        // m_challenge.Paste();
						m_password.SetFocus();
	                    m_password.SetSel(0, -1, TRUE);
					}
                }
                CloseClipboard();
            }
        }
    }
}

// Useless under Windows CE
#ifndef _WIN32_WCE
	void CKeyDlg::OnDrawClipboard()
	{
		// paste clipboard text into challenge
		if (m_cbviewer) {
			if (OpenClipboard()) {
				HANDLE handle = GetClipboardData(CF_TEXT);
				if (handle) {
					CString s = (char *)GlobalLock(handle);	
					GlobalUnlock(handle);					
					CloseClipboard();
					int algorithm, sequence;
					CString seed;
					if (KeyParseChallenge(s, algorithm, sequence, seed))
					{	
							WINDOWPLACEMENT wndpl;
							GetWindowPlacement(&wndpl);
							wndpl.showCmd = SW_SHOWNORMAL;
							SetWindowPlacement(&wndpl);					
							SetForegroundWindow();
					}
				}
				CloseClipboard();
			}
		}
	
			if (m_viewer)
				::SendMessage(m_viewer, WM_DRAWCLIPBOARD, 0, 0);
	}
#endif

// Useless under Windows CE
#ifndef _WIN32_WCE
	void CKeyDlg::OnChangeCbChain(HWND hWndRemove, HWND hWndAfter)
	{
		if (m_viewer == hWndRemove)
			m_viewer = hWndAfter;

		if (m_viewer)
			::SendMessage(m_viewer, WM_CHANGECBCHAIN, (WPARAM)hWndRemove, (LPARAM)hWndAfter);
	}
#endif

void CKeyDlg::OnDestroy() 
{
// This Method ChangeClipboardChain is not supported under Windows CE
#ifndef _WIN32_WCE
	ChangeClipboardChain(m_viewer);
#endif

	// delete task bar icon
	if (m_taskbar)
	{
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		Shell_NotifyIcon(NIM_DELETE, &tnid);
	}

	CDialog::OnDestroy();
	PostMessage(WM_QUIT);
}

void CKeyDlg::OnHelp() 
{
	AfxGetApp()->WinHelp(What_is_WinKey);
}

void CKeyDlg::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);

	// save current window position to preferences
	if (!IsIconic()) {
		RECT rect;   
		GetWindowRect(&rect);
		theApp.WriteProfileInt(_T("Location"), _T("Left"), rect.left);
		theApp.WriteProfileInt(_T("Location"), _T("Top"), rect.top);
	}
}

BOOL CKeyDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(Using_WinKey);
	return TRUE;
	//return CDialog::OnHelpInfo(pHelpInfo);
}

LRESULT CKeyDlg::OnTaskTray(WPARAM wParam, LPARAM lParam)
{
	UINT uMouseMsg = (UINT)lParam;

	if (uMouseMsg == WM_LBUTTONDOWN || uMouseMsg == WM_LBUTTONDBLCLK)
	{
// WINDOWPLACEMENT Structure not supported under Windows CE
#ifndef _WIN32_WCE
		WINDOWPLACEMENT wndpl;
		GetWindowPlacement(&wndpl);
		wndpl.showCmd = SW_SHOWNORMAL;
		SetWindowPlacement(&wndpl);					
		SetForegroundWindow();
#endif
	}

    if (uMouseMsg == WM_RBUTTONUP)
    {
		POINT mouse;
		SetForegroundWindow();
		GetCursorPos(&mouse);
// TPM_RIGHTBUTTON not suported under Windows CE
#ifdef _WIN32_WCE
		m_menu.GetSubMenu(0)->TrackPopupMenu(TPM_RIGHTALIGN,
											 mouse.x, mouse.y, this, NULL);
#else
		m_menu.GetSubMenu(0)->TrackPopupMenu(TPM_RIGHTALIGN | TPM_RIGHTBUTTON,
											 mouse.x, mouse.y, this, NULL);
#endif
        PostMessage(WM_USER);
    }

	return 0;
}

void CKeyDlg::OnDisplay()
{
// WINDOWPLACEMENT Structure not supported under Windows CE
#ifndef _WIN32_WCE
	WINDOWPLACEMENT wndpl;
	GetWindowPlacement(&wndpl);
	wndpl.showCmd = SW_SHOWNORMAL;
	SetWindowPlacement(&wndpl);					
	SetForegroundWindow();
#endif
}

void CKeyDlg::OnAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CKeyDlg::OnExit()
{
	DestroyWindow();
}

void CKeyDlg::OnClose() 
{
	if (m_taskbar)
		ShowWindow(SW_HIDE);
	else {
		CDialog::OnClose();
		DestroyWindow();
	}
}
