// WinKey.cpp
// David Aylesworth

#include "stdafx.h"
#include "WinKey.h"
#include "Key.h"
#include "KeyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKeyApp

BEGIN_MESSAGE_MAP(CKeyApp, CWinApp)
	//{{AFX_MSG_MAP(CKeyApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyApp construction

CKeyApp::CKeyApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CKeyApp object

CKeyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CKeyApp initialization

BOOL CKeyApp::InitInstance()
{
		// Standard initialization
// This is not supported under Windows CE!
#ifndef _WIN32_WCE
	#ifdef _AFXDLL
		Enable3dControls();			// Call this when using MFC in a shared DLL
	#else
		Enable3dControlsStatic();	// Call this when linking to MFC statically
	#endif
#endif

	CKeyDlg *pDlg = new CKeyDlg();
	m_pMainWnd = pDlg;

	if (pDlg->Create(IDD_WINKEY_DIALOG) != TRUE)
		return FALSE;

	if (!pDlg->m_starthidden)
		pDlg->ShowWindow(SW_SHOW);
	else if (!pDlg->m_taskbar)
#ifdef _WIN32_WCE
		pDlg->ShowWindow(SW_HIDE);
#else
		pDlg->ShowWindow(SW_SHOWMINIMIZED); // This is not support supported under Windows CE
#endif

#ifdef SESSION_AUTH
	m_winsock = AfxSocketInit();
	m_fwauth = GetProfileInt("Settings", "FirewallAuth", 0);

	if (m_winsock && m_fwauth)
	{
		m_listener = new CListenSocket();
		if (m_listener->Create(261))
			if (m_listener->Listen())
				// if (m_listener->AsyncSelect(FD_ACCEPT))
					return TRUE;

		AfxMessageBox("Could not create authentication socket.");
		delete m_listener;
		m_listener = NULL;
	}
#endif

	return TRUE;
}
