// OptDlg.cpp
// David Aylesworth

#include "stdafx.h"
#include "WinKey.h"
#include "KeyDlg.h"
#include "OptDlg.h"
#include "Help/WinKey.hh"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CKeyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog

COptionsDlg::COptionsDlg(CKeyDlg* pParent /*=NULL*/)
   : CDialog(COptionsDlg::IDD, pParent)
{
    m_parent = pParent;
   
    //{{AFX_DATA_INIT(COptionsDlg)
    m_autopaste = pParent->m_autopaste;
    m_autocopy = pParent->m_autocopy;
    m_autodecrement = pParent->m_autodecrement;
    m_autoclear = FALSE;
	m_appendcrlf = FALSE;
	m_cbviewer = FALSE;
	m_minimize = FALSE;
	m_starthidden = FALSE;
	m_taskbar = FALSE;
	m_fwauth = FALSE;
	m_onetime = FALSE;
	//}}AFX_DATA_INIT
}

void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(COptionsDlg)
    DDX_Check(pDX, IDC_CHECK1, m_autopaste);
    DDX_Check(pDX, IDC_CHECK2, m_autocopy);
    DDX_Check(pDX, IDC_CHECK3, m_autodecrement);
    DDX_Check(pDX, IDC_CHECK4, m_autoclear);
	DDX_Check(pDX, IDC_CHECK5, m_appendcrlf);
	DDX_Check(pDX, IDC_CHECK6, m_cbviewer);
	DDX_Check(pDX, IDC_CHECK7, m_minimize);
	DDX_Check(pDX, IDC_CHECK8, m_starthidden);
	DDX_Check(pDX, IDC_CHECK9, m_taskbar);
	DDX_Check(pDX, IDC_CHECK10, m_fwauth);
	DDX_Check(pDX, IDC_CHECK11, m_onetime);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
    //{{AFX_MSG_MAP(COptionsDlg)
    ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

BOOL COptionsDlg::OnInitDialog() 
{
    CDialog::OnInitDialog();

    // copy global flags
    m_autopaste = (BOOL)m_parent->m_autopaste;
    m_autocopy = (BOOL)m_parent->m_autocopy;
    m_autodecrement = (BOOL)m_parent->m_autodecrement;
    m_autoclear = (BOOL)m_parent->m_autoclear;
    m_appendcrlf = (BOOL)m_parent->m_appendcrlf;
#ifndef	_WIN32_WCE
	m_cbviewer = (BOOL)m_parent->m_cbviewer;	// Useless under Windows CE
#endif
	m_minimize = (BOOL)m_parent->m_hide;
	m_starthidden = (BOOL)m_parent->m_starthidden;
	m_taskbar = (BOOL)m_parent->m_taskbar;
	m_onetime = (BOOL)m_parent->m_onetime;
	m_fwauth = (BOOL)theApp.m_fwauth;
    UpdateData(FALSE);
    CheckRadioButton(IDC_MD4, IDC_MD5, IDC_MD4 + m_parent->m_algorithm);
      
    return TRUE;
}

void COptionsDlg::OnCancel() 
{
    CDialog::OnCancel();
}

void COptionsDlg::OnOK() 
{
    UpdateData(TRUE);

    // set global flags   
    m_parent->m_autopaste = (int)m_autopaste;
    m_parent->m_autocopy = (int)m_autocopy;
    m_parent->m_autodecrement = (int)m_autodecrement;
    m_parent->m_autoclear = (int)m_autoclear;
    m_parent->m_appendcrlf = (int)m_appendcrlf;
#ifndef _WIN32_WCE	
	m_parent->m_cbviewer = (int)m_cbviewer;	// Uselesse under Windows CE
#endif
	m_parent->m_hide = (int)m_minimize;
	m_parent->m_starthidden = (int)m_starthidden;
	m_parent->m_onetime = (int)m_onetime;
	// theApp.m_fwauth = (int)m_fwauth;
    m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

	// add/remove taskbar icon
	if (m_taskbar && !m_parent->m_taskbar)
	{
		// add taskbar icon
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_parent->m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
		tnid.uCallbackMessage = UWM_TASKTRAY;
		tnid.hIcon = m_parent->m_hIcon;
		// lstrcpyn not available on Windows CE
		_tcsncpy(tnid.szTip, _T("WinKey"), sizeof(tnid.szTip));	// Modified for Windows CE
			/*
			lstrcpyn(tnid.szTip, "WinKey", sizeof(tnid.szTip));
			*/
		m_taskbar = Shell_NotifyIcon(NIM_ADD, &tnid);

		m_parent->m_taskbar = (int)m_taskbar;
	}
	else if (!m_taskbar && m_parent->m_taskbar)
	{
		// delete task bar icon
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_parent->m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		Shell_NotifyIcon(NIM_DELETE, &tnid);

		// show window in case it's hidden
// WINDOWPLACEMENT Structure not supported under Windows CE
#ifndef _WIN32_WCE		
		WINDOWPLACEMENT wndpl;
		m_parent->GetWindowPlacement(&wndpl);
		wndpl.showCmd = SW_SHOW;
		m_parent->SetWindowPlacement(&wndpl);					

		m_parent->m_taskbar = (int)m_taskbar;
#endif
	}

    CDialog::OnOK();
}

void COptionsDlg::OnSave()
{
    UpdateData(TRUE);

    // set global flags   
    m_parent->m_autopaste = (int)m_autopaste;
    m_parent->m_autocopy = (int)m_autocopy;
    m_parent->m_autodecrement = (int)m_autodecrement;
    m_parent->m_autoclear = (int)m_autoclear;
    m_parent->m_appendcrlf = (int)m_appendcrlf;
#ifndef _WIN32_WCE    
	m_parent->m_cbviewer = (int)m_cbviewer;	// Useless under Windows CE
#endif
	m_parent->m_hide = (int)m_minimize;
	m_parent->m_starthidden = (int)m_starthidden;
	m_parent->m_onetime = (int)m_onetime;
	// theApp.m_fwauth = (int)m_fwauth;
    m_parent->m_algorithm = GetCheckedRadioButton(IDC_MD4, IDC_MD5) - IDC_MD4;

    // save defaults
    theApp.WriteProfileInt(_T("Settings"), _T("AutoCopy"), m_parent->m_autocopy);
    theApp.WriteProfileInt(_T("Settings"), _T("AutoPaste"), m_parent->m_autopaste);
    theApp.WriteProfileInt(_T("Settings"), _T("AutoDecrement"), m_parent->m_autodecrement);
    theApp.WriteProfileInt(_T("Settings"), _T("AutoClear"), m_parent->m_autoclear);
    theApp.WriteProfileInt(_T("Settings"), _T("AppendCRLF"), m_parent->m_appendcrlf);
#ifndef _WIN32_WCE    
	theApp.WriteProfileInt(_T("Settings"), _T("CBViewer"), m_parent->m_cbviewer); // Useless under Windows CE
#endif    
	theApp.WriteProfileInt(_T("Settings"), _T("AutoMinimize"), m_parent->m_hide);
    theApp.WriteProfileInt(_T("Settings"), _T("HideOnStartup"), m_parent->m_starthidden);
	theApp.WriteProfileInt(_T("Settings"), _T("AutoExit"), m_parent->m_onetime);
	theApp.WriteProfileInt(_T("Settings"), _T("FirewallAuth"), (int)m_fwauth);
    theApp.WriteProfileString(_T("Settings"), _T("Algorithm"), m_parent->m_algorithm ? _T("MD5") : _T("MD4"));
 
	// add/remove taskbar icon
	if (m_taskbar && !m_parent->m_taskbar)
	{
		// add taskbar icon
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_parent->m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
		tnid.uCallbackMessage = UWM_TASKTRAY;
		tnid.hIcon = m_parent->m_hIcon;
		// lstrcpyn not available on Windows CE
		_tcsncpy(tnid.szTip, _T("WinKey"), sizeof(tnid.szTip)); // Modified for Windows CE
			/*
				lstrcpyn(tnid.szTip, "WinKey", sizeof(tnid.szTip));
			*/
		m_taskbar = Shell_NotifyIcon(NIM_ADD, &tnid);

		m_parent->m_taskbar = (int)m_taskbar;
	}
	else if (!m_taskbar && m_parent->m_taskbar)
	{
		// delete task bar icon
		NOTIFYICONDATA tnid;
		tnid.cbSize = sizeof (NOTIFYICONDATA);
		tnid.hWnd = m_parent->m_hWnd;
		tnid.uID = IDR_MAINFRAME;
		Shell_NotifyIcon(NIM_DELETE, &tnid);

		// show window in case it's hidden		
// WINDOWPLACEMENT Structure not supported under Windows CE
#ifndef _WIN32_WCE
		WINDOWPLACEMENT wndpl;
		m_parent->GetWindowPlacement(&wndpl);
		wndpl.showCmd = SW_SHOW;
		m_parent->SetWindowPlacement(&wndpl);					

		m_parent->m_taskbar = (int)m_taskbar;
#endif
	}

    theApp.WriteProfileInt(_T("Settings"), _T("TaskbarIcon"), m_parent->m_taskbar);

    CDialog::OnOK();
}

BOOL COptionsDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	AfxGetApp()->WinHelp(Options);
	return TRUE;
	//return CDialog::OnHelpInfo(pHelpInfo);
}
