/*
 * util.c	Various utility functions.
 *
 * Version:     @(#)util.c  2.20  17-Jul-1999  miquels@cistron.nl
 */

char util_sccsid[] =
"@(#)util.c	2.20 Copyright 1997-1999 Cistron Internet Services B.V.";

#include	"autoconf.h"

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>
#include	<signal.h>

#include	"radiusd.h"

/*
 *	Return a printable host name (or IP address in dot notation)
 *	for the supplied IP address.
 */
char * ip_hostname(UINT4 ipaddr)
{
	struct		hostent *hp;
	static char	hstname[128];

	hp = gethostbyaddr((char *)&ipaddr, sizeof (struct in_addr), AF_INET);
	if (hp == 0) {
		ip_ntoa(hstname, ipaddr);
		return(hstname);
	}
	return (char *)hp->h_name;
}


/*
 *	Return an IP address in from a host
 *	name or address in dot notation.
 */
UINT4 ip_getaddr(char *host)
{
	struct hostent	*hp;
	UINT4		a, ip_addr();

	if ((a = ip_addr(host)) != 0)
		return a;

	if ((hp = gethostbyname(host)) == NULL)
		return (UINT4)0;

	return (*(UINT4 *)hp->h_addr);
}


/*
 *	Return an IP address in standard dot notation
 */
char *ip_ntoa(char *buffer, UINT4 ipaddr)
{
	struct in_addr	in;
	char		*r;

	in.s_addr = ipaddr;
	r = inet_ntoa(in);

	if (buffer)
		strcpy(buffer, inet_ntoa(in));
	return buffer ? buffer : r;
}


/*
 *	Return an IP address from
 *	one supplied in standard dot notation.
 */
UINT4 ip_addr(char *ip_str)
{
	struct in_addr	in;

	if (inet_aton(ip_str, &in) == 0)
		return 0;
	return in.s_addr;
}


/*
 *	Call getpwnam but cache the result.
 */
struct passwd *rad_getpwnam(char *name)
{
	static struct passwd *lastpwd;
	static char lastname[64];
	static time_t lasttime = 0;
	time_t now;

	now = time(NULL);

	if ((now <= lasttime + 5 ) && strncmp(name, lastname, 64) == 0)
		return lastpwd;

	strncpy(lastname, name, 63);
	lastname[63] = 0;
	lastpwd = getpwnam(name);
	lasttime = now;

	return lastpwd;
}

#if defined (sun) && defined(__svr4__)
/*
 *	The signal() function in Solaris 2.5.1 sets SA_NODEFER in
 *	sa_flags, which causes grief if signal() is called in the
 *	handler before the cause of the signal has been cleared.
 *	(Infinite recursion).
 */
void (*sun_signal(int signo, void (*func)(int)))(int)
{
	struct sigaction act, oact;

	act.sa_handler = func;
	sigemptyset(&act.sa_mask);
	act.sa_flags = 0;
#ifdef  SA_INTERRUPT		/* SunOS */
	act.sa_flags |= SA_INTERRUPT;
#endif
	if (sigaction(signo, &act, &oact) < 0)
		return SIG_ERR;
	return oact.sa_handler;
}
#endif

