#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>
#include	<unistd.h>
#include	<signal.h>
#include	<errno.h>
#include	<sys/wait.h>
#include	<utmp.h>

#include	"radiusd.h"
#include	"radutmp.h"

static char trans[64] =
   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
#define ENC(c) trans[c]

char *radius_dir = RADIUS_DIR;
char *progname   = "pmzap";

/*
 *	UUencode 4 bits. We use this to turn a 4 byte field
 *	(an IP adres) into 6 bytes of ASCII.
 */
static char *uue(void *in)
{
	int i;
	static unsigned char res[7];
	unsigned char *data = (char *)in;

	res[0] = ENC(data[0] >> 2);
	res[1] = ENC((data[0] << 4) & 060) + ((data[1] >> 4) & 017);
	res[2] = ENC((data[1] << 2) & 074) + ((data[2] >> 6) & 03);
	res[3] = ENC(data[2] & 077);

	res[4] = ENC(data[3] >> 2);
	res[5] = ENC((data[3] << 4) & 060);
	res[6] = 0;

	for(i = 0; i < 6; i++) {
		if (res[i] == ' ') res[i] = '`';
		if (res[i] < 32 || res[i] > 127)
			printf("uue: protocol error ?!\n");
	}
	return res;
}


static char *shortname(UINT4 ip)
{
	FILE	*clientfd;
	u_char	buffer[128];
	char	hostnm[256];
	u_char	secret[64];
	static	char	shortnm[64];
	UINT4	ipaddr;
	UINT4	get_ipaddr();
	char	*ip_hostname();

	/* Find the client in the database */
	sprintf(buffer, "%s/%s", radius_dir, RADIUS_CLIENTS);
	if((clientfd = fopen(buffer, "r")) == (FILE *)NULL) {
		fprintf(stderr, "%s: couldn't open %s to find clients\n",
				progname, buffer);
		return(NULL);
	}
	ipaddr = (UINT4)0;
	while(fgets(buffer, sizeof(buffer), clientfd) != (char *)NULL) {
		if(*buffer == '#') {
			continue;
		}
		shortnm[0] = 0;
		if(sscanf(buffer, "%s%s%s", hostnm, secret, shortnm) != 3) {
			continue;
		}
		ipaddr = get_ipaddr(hostnm);
		if(ipaddr == ip) {
			break;
		}
	}
	fclose(clientfd);

	return shortnm[0] ? shortnm : NULL;
}

/*
 *	Zap a user from the radutmp and radwtmp file.
 */
int main(int argc, char **argv)
{
	struct radutmp ut;
	struct utmp wt;
	FILE *fp;
	char *s;
	int nas_port, fd;
	struct hostent *h;
	time_t t;
	char utline[8];
	char buf[32];
	UINT4 ip;

	if (argc != 4) {
		fprintf(stderr, "Usage: pmzap <user> <port> <termserver>\n");
		exit(1);
	}
	s = argv[2];
	if (*s == 's' || *s == 'S') s++;
	nas_port = atoi(s);
	sprintf(utline, "S%d", nas_port);

	time(&t);
	memset(&wt, 0, sizeof(wt));

	/*
	 *	Get the full hostname of the terminal server.
	 */
	if ((h = gethostbyname(argv[3])) == NULL) {
		herror(argv[3]);
		exit(1);
	}

	/*
	 *	We use the tty field to store the terminal servers' port
	 *	and address so that the tty field is unique.
	 */
	ip = *(UINT4 *)h->h_addr;
	s  = shortname(ntohl(ip));
	if (s == NULL) s = uue(&ip);
#if UT_LINESIZE > 8
	sprintf(buf, "%03d:%s", nas_port, s);
#else
	sprintf(buf, "%02d%s", nas_port, s);
#endif
	strncpy(wt.ut_line, buf, UT_LINESIZE);
	wt.ut_time = t;
#ifdef DEAD_PROCESS
	wt.ut_type = DEAD_PROCESS;
#endif

	if ((fd = open(RADUTMP, O_RDWR)) >= 0) {
		/*
		 *	Delete all entries having our server/port
		 */
		while(read(fd, &ut, sizeof(ut)) == sizeof(ut)) {
			if (strncmp(ut.ut_name, argv[1],   RUT_NAMESIZE) == 0 &&
			    strncmp(ut.ut_line, utline,    RUT_LINESIZE) == 0 &&
			    strncmp(ut.ut_serv, h->h_name, RUT_SERVSIZE) == 0) {
				memset(&ut, 0, sizeof(ut));
				lseek(fd, -sizeof(ut), SEEK_CUR);
				write(fd, &ut, sizeof(ut));
			}
		}
		close(fd);
	}

	/*
	 *	Write logout record to RADIUS wtmp log file.
	 */
	if ((fp = fopen(RADWTMP, "a")) != NULL) {
		fwrite(&wt, sizeof(wt), 1, fp);
		fclose(fp);
	}

	return 0;
}
