/*
 * radutmp.h	Definitions for the Radius UTMP file.
 *
 * Version:	@(#)radutmp  2.00  30-Jul-1996  MvS.
 */

#ifndef _RADUTMP_H
#define _RADUTMP_H

#define RADUTMP "/var/run/radutmp"
#define RADWTMP "/var/log/radwtmp"

/*
 *      Types of connection.
 */
#ifndef P_UNKNOWN
#  define P_UNKNOWN       0
#  define P_LOCAL         'L'
#  define P_RLOGIN        'R'
#  define P_SLIP          'S'
#  define P_CSLIP         'C'
#  define P_PPP           'P'
#  define P_AUTOPPP       'A'
#  define P_TELNET        'E'
#  define P_TCPCLEAR      'T'
#  define P_TCPLOGIN      'U'
#  define P_CONSOLE       '!'
#  define P_SHELL         'X'
#endif

#define P_UNUSED	0
#define P_LOGOUT	0
#define P_LOGIN		1

#if RADUTMP_VER == 1

#define RUT_HOSTSIZE 32
#define RUT_NAMESIZE 16
#define RUT_LINESIZE 12
#define RUT_SERVSIZE 32

struct radutmp {
  char ut_name[RUT_NAMESIZE];  /* Loginname */
  char ut_host[RUT_HOSTSIZE];  /* Hostname [dynamic IP address] */
  char ut_line[RUT_LINESIZE];  /* port id */
  char ut_serv[RUT_SERVSIZE];  /* Name of terminal server. */
  char ut_id[4];                /* Ppp, Slip, Terminal */
  time_t ut_time;              /* Start of login. */
};

#else /* RADUTMP_VER == 2 */

struct radutmp {
  char login[32];		/* Loginname */
  int  port;			/* Port on the terminal server (32 bits). */
  unsigned int server_ip;	/* IP of portmaster. */
  unsigned int client_ip;	/* SLIP/PPP address or login-host. */
  int proto;			/* Protocol. */
  time_t ut_time;		/* Start of session. */
  time_t length;		/* End of session. */
  int type;			/* Type of entry. */
};

#endif /* RADUTMP_VER */

#endif /* _RADUTMP_H */
