/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

/*
 *	@(#)radiusd.h	2.0  03-Aug-1996
 */

#include "sysdep.h"
#include "radius.h"
#include "conf.h"

/* Server data structures */

typedef struct dict_attr {
	char			name[32];
	int			value;
	int			type;
	struct dict_attr	*next;
} DICT_ATTR;

typedef struct dict_value {
	char			attrname[32];
	char			name[32];
	int			value;
	struct dict_value	*next;
} DICT_VALUE;

typedef struct value_pair {
	char			name[32];
	int			attribute;
	int			type;
	UINT4			lvalue;
	char			strvalue[AUTH_STRING_LEN];
	struct value_pair	*next;
} VALUE_PAIR;

typedef struct auth_req {
	UINT4			ipaddr;
	u_short			udp_port;
	u_char			id;
	u_char			code;
	u_char			vector[16];
	u_char			secret[16];
	VALUE_PAIR		*request;
	int			child_pid;	/* Process ID of child */
	UINT4			timestamp;
	struct auth_req		*next;		/* Next active request */
} AUTH_REQ;

#define DEBUG	if(debug_flag)printf

#define SECONDS_PER_DAY		86400
#define MAX_REQUEST_TIME	30
#define CLEANUP_DELAY		5
#define MAX_REQUESTS		100

/*
 *	Global variables.
 */
extern char		recv_buffer[4096];
extern char		send_buffer[4096];
extern char		*progname;
extern int		debug_flag;
extern char		*radacct_dir;
extern char		*radius_dir;
extern UINT4		expiration_seconds;
extern UINT4		warning_seconds;
extern int		radius_pid;

/*
 *	Function prototypes.
 */

/* util.c */
char *		ip_hostname 	PROTO((UINT4));
UINT4		get_ipaddr 	PROTO((char *));
int		good_ipaddr 	PROTO((char *));
void		ipaddr2str 	PROTO((char *, UINT4));
void		pairfree 	PROTO((VALUE_PAIR *));
UINT4		ipstr2long 	PROTO((char *));
struct passwd *	rad_getpwnam 	PROTO((char *));
VALUE_PAIR *	pairfind 	PROTO((VALUE_PAIR *, int));
void		pairdelete	PROTO((VALUE_PAIR **, int));

/* users.c */
int		user_find	PROTO((char *name, VALUE_PAIR *,
					VALUE_PAIR **, VALUE_PAIR **));
int		hints_setup	PROTO((VALUE_PAIR *request_pairs));
int		huntgroup_access PROTO((VALUE_PAIR *request_pairs));
#ifdef CISTRON_COMPAT
char *		cistron_compat	PROTO((VALUE_PAIR *request, VALUE_PAIR *reply));
#endif

