#! /usr/bin/perl
#
# checkrad.pl	See if a user is (still) logged in on a certain port.
#
#		This is used by the cistron-radius server to check
#		if its idea of a user logged in on a certain port/nas
#		is correct if a double login is detected.
#
# Called as:	nas_type nas_ip nas_port login session_id
#
# Returns:	0 = no duplicate, 1 = duplicate, >1 = error.
#
# Version:	@(#)checkrad.pl  1.08  04-Jul-1998  miquels@cistron.nl
#
#		max40xx_finger	 1.0	Author: costa@mdi.ca
#		computone_finger 1.0	Author: costa@mdi.ca
#		sub tc_tccheck	 1.1	Author: alexisv@compass.com.ph
#
#
#	Config: $debug is the file you want to put debug messages in
#		$snmpget is the location of your ``snmpget'' program
#		$naspass is the location of your NAS admin password file
#
$debug   = '';
#$debug	 = '/var/log/checkrad.log';

$snmpget = '/usr/bin/snmpget';
$naspass = '/etc/raddb/naspasswd';

#
#	PM3:	$lv_offs is where the last S port is before one or two
#		ports are skipped (22 or 29, for US or Europe)
#		$lv_hole is the size of the hole (1 or 2, for US or Europe).
#
$lv_offs = 29;
$lv_hole = 2;

#
#	Try to load Net::Telnet, but do not complain if we cannot
#	find it. Prefer a locally installed copy.
#
BEGIN {
	unshift @INC, "/usr/local/lib/site_perl";
	eval "use Net::Telnet 3.00;";
	$::HAVE_NET_TELNET = ($@ eq "");
};

#
#	See if the user is logged in using the Livingston MIB.
#	We don't check the username but the session ID.
#
$lvm	 = '.iso.org.dod.internet.private.enterprises.307';
sub livingston_snmp {

	#
	#	First find out the offset (ugly!!). Also, if the portno
	#	is greater than 29, substract 2 (S30 and S31 don't exist).
	#	You might need to change this to 23 and 1 for the USA.
	#
	$_ = `$snmpget $ARGV[1] public $lvm.3.2.1.1.1.2.5`;
	($xport) = /^.*\"S([0-9]+)".*$/;
	$xport += 0;
	$portidx = $ARGV[2] + (5 - $xport);
	$portidx -= $lv_hole if ($ARGV[2] > $lv_offs);
	chop;
	print LOG "  using $xport offset for port / SNMPno translation\n"
		if ($debug);

	#
	#	Now get the session id from the terminal server.
	#
	$_ = `$snmpget $ARGV[1] public $lvm.3.2.1.1.1.5.$portidx`;
	($sessid) = /^.*\"([^"]+)".*$/;

	print LOG "  session id at port S$ARGV[2]: $sessid\n" if ($debug);

	($sessid eq $ARGV[4]) ? 1 : 0;
}

#
#	See if the user is logged in using the Cisco MIB
#
$csm	 = '.iso.org.dod.internet.private.enterprises.9';
sub cisco_snmp {
	$_ = `$snmpget $ARGV[1] public $csm.2.9.2.1.18.$ARGV[2]`;
	($login) = /^.*\"([^"]+)".*$/;

	print LOG "  user at port S$ARGV[2]: $login\n" if ($debug);

	($login eq $ARGV[3]) ? 1 : 0;
}

#
#	Check a Computone Powerrack # via finger
#
#	Author: Shiloh Costa of MDI Internet Inc. <costa@mdi.ca>
#
sub computone_finger {
	$online = 0;
	open(FD, "finger \@$ARGV[1]|");
	while(<FD>) {  
	   @line = <FD>;
	   }
	 $numline = @line;
	 for ($num = 0; $num < $numline; $num++) {
	   if( $line[$num]  =~ /$ARGV[3] / ){
	     #print "$ARGV[3] is online\n";
	     $online = 1; # user is online
	   }
	 }
	close FD;
	return $online;
}

#
#	Check an Ascend Max4000 or similar model# via finger
#
#	Note: Not all software revisions support finger
#	      You may also need to enable the finger option.
#
#	Author: Shiloh Costa of MDI Internet Inc. <costa@mdi.ca>
#
sub max40xx_finger {
	open(FD, "finger $ARGV[3]\@$ARGV[1]|");
	while(<FD>) {
	   $line = <FD>;
	   if( $line =~ /Session/ ){
	      return 1; # user is online
	   }else{
	      return 0; # user is offline
	   }
	}
	close FD;
}

#
#	See if the user is logged in using the portslave finger.
#
sub portslave_finger {
	my ($Port_seen);

	$Port_seen = 0;

	open(FD, "finger \@$ARGV[1]|");
	while(<FD>) {
		#
		#	Check for ^Port. If we don't see it we
		#	wont get confused by non-portslave-finger
		#	output too.
		#
		if (/^Port/) {
			$Port_seen++;
			next;
		}
		next if (!$Port_seen);
		next if (/^---/);

		($port, $user) = /^.(...) (...............)/;

		$port =~ s/ .*//;
		$user =~ s/ .*//;
		$ulen = length($user);
		#
		#	HACK: strip [PSC] from the front of the username,
		#	and things like .ppp from the end.
		#
		$user =~ s/^[PSC]//;
		$user =~ s/\.(ppp|slip|cslip)$//;

		#
		#	HACK: because ut_user usually has max. 8 characters
		#	we only compare up the the length of $user if the
		#	unstripped name had 8 chars.
		#
		$argv_user = $ARGV[3];
		if ($ulen == 8) {
			$ulen = length($user);
			$argv_user = substr($ARGV[3], 0, $ulen);
		}

		if ($port == $ARGV[2]) {
			if ($user eq $argv_user) {
				print LOG "  $user matches $argv_user " .
					"on port $port" if ($debug);
				close FD;
				return 1;
			} else {
				print LOG "  $user doesn't match $argv_user " .
					"on port $port" if ($debug);
				close FD;
				return 0;
			}
		}
	}
	close FD;
	0;
}

#
#	See if the user is already logged-in at the 3Com/USR Total Control.
#	(this routine by Alexis C. Villalon <alexisv@compass.com.ph>).
#	You must have the Net::Telnet module from CPAN for this to work.
#	You must also have your /etc/raddb/naspasswd made up.
# 
sub tc_tccheck {
	#
	#	Localize all variables first.
	#
	my ($Port_seen, $ts, $terminalserver, $log, $login, $pass, $password);
	my ($telnet, $curprompt, $curline, $ok, $totlines, $ccntr);
	my (@curlines, @cltok, $user, $port, $ulen);

	if (!$::HAVE_NET_TELNET) {
		print LOG
		"  checkrad: Net::Telnet 3.00+ CPAN module not installed\n"
		if ($debug);
		print STDERR
		"checkrad: Net::Telnet 3.00+ CPAN module not installed\n";
		return 2;
	}

	$terminalserver = $ARGV[1];
	$Port_seen = 0;
	#
	#	Get login name and password for a certain NAS from $naspass.
	#
	unless (open(FD, $naspass)) {
		print LOG "tccheck: naspasswd file not found; possible " . 
			"match for $ARGV[3]\n" if ($debug);
		print STDERR "tccheck: naspassswd file not found; possible " .
			"match for $ARGV[3]\n";
		return 2;
	}
	while (<FD>) {
		chop;
		next if (m/^(#|$|[\t ]+$)/);
		($ts, $log, $pass) = split(/\s+/, $_, 3);
		if ($ts eq $terminalserver) {
			$login = $log;
			$password = $pass;
			last;
		}
	}
	close FD;
	if ($password eq "") {
		print LOG "tccheck: password for $ARGV[1] is null; " .
			"possible match for $ARGV[3] on " . 
			"port $ARGV[2]\n" if ($debug);
		print STDERR "tccheck: password for $ARGV[1] is null; " .
			"possible match for $ARGV[3] on port $ARGV[2]\n"; 
		return 2;
	}
	#
	#	Communicate with NAS using Net::Telnet, then issue
	#	the command "show sessions" to see who are logged in.
	#	Thanks to Chris Jackson <chrisj@tidewater.net> for the
	#	for the "-- Press Return for More --" workaround.
	#
	$telnet = new Net::Telnet (Timeout => 10,
				   Prompt => '/\>/');
	$telnet->open($terminalserver);
	$telnet->login($login, $password);
	$telnet->print("show sessions");
	while ($curprompt ne "\>") {
		($curline, $curprompt) = $telnet->waitfor
			(String => "-- Press Return for More --",
			 String => "\>",
			 Timeout => 10);
		$ok = $telnet->print("");
		push @curlines, split(/^/m, $curline);
	}
	$telnet->close;
	#
	#	Telnet closed.  We got the info.  Let's examine it.
	#
	$totlines = @curlines;
	$ccntr = 0;
	while($ccntr < $totlines) {
		#
		#	Check for ^Port.
		#
		if ($curlines[$ccntr] =~ /^Port/) {
			$Port_seen++;
			$ccntr++;
			next;
		}
		#
		#	Ignore all unnecessary lines.
		#
		if (!$Port_seen || $curlines[$ccntr] =~ /^---/ ||
			$curlines[$ccntr] =~ /^ .*$/) {
			$ccntr++;
			next;
		}
		#
		#	Parse the current line for the port# and username.
		#
		@cltok = split(/\s+/, $curlines[$ccntr]);
		$ccntr++;
		$port = $cltok[0];
		$user = $cltok[1];
		$ulen = length($user);
		#
		#	HACK: strip [PSC] from the front of the username,
		#	and things like .ppp from the end.  Strip S from
		#	the front of the port number.
		#
		$user =~ s/^[PSC]//;
		$user =~ s/\.(ppp|slip|cslip)$//;
		$port =~ s/^S//;
		#		
		#	HACK: because "show sessions" shows max. 15 characters
		#	we only compare up to the length of $user if the
		#	unstripped name had 15 chars.
		#
		$argv_user = $ARGV[3];
		if ($ulen == 15) {
			$ulen = length($user);
			$argv_user = substr($ARGV[3], 0, $ulen);
		}
		if ($port == $ARGV[2]) {
			if ($user eq $argv_user) {
				print LOG "  $user matches $argv_user " .
					"on port $port" if ($debug);
				return 1;
			} else {
				print LOG "  $user doesn't match $argv_user " .
					"on port $port" if ($debug);
				return 0;
			}
		}
	}
	0;
}

if ($debug) {
	open(LOG, ">>$debug");
	$now = localtime;
	print LOG "$now checkrad @ARGV\n";
}

if ($#ARGV != 4) {
	print LOG "Usage: checkrad nas_type nas_ip " .
			"nas_port login session_id\n" if ($debug);
	print STDERR "Usage: checkrad nas_type nas_ip " .
			"nas_port login session_id\n";
	close LOG if ($debug);
	exit(2);
}

if ($ARGV[0] eq 'livingston') {
	$ret = &livingston_snmp;
} elsif ($ARGV[0] eq 'cisco') {
	$ret = &cisco_snmp;
} elsif ($ARGV[0] eq 'computone') {
	$ret = &computone_finger;
} elsif ($ARGV[0] eq 'max40xx') {
	$ret = &max40xx_finger;
} elsif ($ARGV[0] eq 'portslave') {
	$ret = &portslave_finger;
} elsif ($ARGV[0] eq 'tc') {
	$ret = &tc_tccheck;
} elsif ($ARGV[0] eq 'other') {
	$ret = 0;
} else {
	print LOG "  checkrad: unknown NAS type $ARGV[0]\n" if ($debug);
	print STDERR "checkrad: unknown NAS type $ARGV[0]\n";
	$ret = 2;
}

if ($debug) {
	$mn = "login ok";
	$mn = "double detected" if ($ret == 1);
	$mn = "error detected" if ($ret == 2);
	print LOG "  Returning $ret ($mn)\n";
	close LOG;
}

exit($ret);
