/*
 * sysdep.h	Include system dependant things, and define
 *		compatibility stuff.
 *
 * Version:	@(#)sysdep.h  1.5  20-Jan-1998
 */

#ifndef SYSDEP_H_INCLUDED
#define SYSDEP_H_INCLUDED

#if defined(__alpha) && (defined(__osf__) || defined(__linux__))
typedef unsigned int	UINT4;
#else
typedef unsigned long	UINT4;
#endif

#ifdef BSD
#include        <strings.h>
#else
#include        <string.h>
#endif

#if defined(bsdi)
#include        <machine/inline.h>
#include        <machine/endian.h>
#else	/* bsdi */
# ifdef __FreeBSD__
#  include        <stdlib.h>
# else
#  include        <malloc.h>
# endif  /* FreeBSD */
#endif	/* bsdi */

#if defined(aix)
#include	<sys/select.h>
#endif	/* aix 	*/

/* UTMP stuff. Uses utmpx on svr4 */
#ifdef __svr4__
#  include <utmpx.h>
#  include <sys/fcntl.h>
#  define utmp utmpx
#  define UT_NAMESIZE	32
#  define UT_LINESIZE	32
#  define UT_HOSTSIZE	257
#else
#  include <utmp.h>
#endif
#ifdef __osf__
#  define UT_NAMESIZE	32
#  define UT_LINESIZE	32
#  define UT_HOSTSIZE	64
#endif
#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(bsdi)
#  ifndef UTMP_FILE
#    define UTMP_FILE "/var/run/utmp"
#  endif
#  define ut_user ut_name
#endif

#endif /* SYSDEP_H_INCLUDED */
