/*
 * flowmux.h	
 *
 * Version:	$Id:$
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2000  The FreeRADIUS server project
 * Copyright 2001  Mark Fullmer and The Ohio State University
 * Copyright 2002  Nikolay P. Romanyuk <mag@vtelecom.ru>
 */

#define SELECT_TIMEOUT	1		/* 1 sec. */
#define	MYMAX(a,b)	((a)>(b)?(a):(b))
#define BUFSIZE		2048		/* buffer for Flow packet */
#define MAX_CONNS	5
#define RESERVED_CONS	1

struct ip_param {
	in_addr_t loc_ip;
	in_addr_t rem_ip;
	u_short port;
	struct sockaddr_in loc_addr;
	struct sockaddr_in rem_addr;
	int sock;
};

struct ip_count {
	u_int32_t addr;
	struct {
		time_t timestamp;	/* begin account */
		int state;
#define	FLOW_ACCT_ON	1		/* accounting on */
#define FLOW_ACCT_OFF	0		/* accounting off */
		u_long count;
	} rec[256];			/* Class 'C' network */
	struct ip_count *next;
};

struct msgip {
	struct cmsghdr hdr;
#ifdef IP_RECVDSTADDR
	struct in_addr ip;
#else
#ifdef IP_PKTINFO
	struct in_pktinfo pktinfo;
#endif /* else */
#endif /* IP RECVDSTADDR */
};

struct msgbuf {
	struct msghdr msg;
	struct iovec iov[1];
	struct msgip msgip;
	int inb;
	char buf[BUFSIZE];
};

struct cmd {
	int cmd;
#define FLOW_ACCT_START	1
#define FLOW_ACCT_STOP	2
#define FLOW_ACCT_SEND	3
	u_int32_t addr;
};

void usage(char *);
void flowlog(const char *, ...);
in_addr_t get_ip(char *);
struct ip_param *conf_ip(char *, int);
int pdu_decode(struct msgbuf *);

/* From Flow-Tools. See: http://www.splintered.net/sw/flow-tools/ */
#ifndef BIG_ENDIAN
#define BIG_ENDIAN 4321		/* i386, vax */
#endif

#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234	/* 68000, ibm, net */
#endif

#ifndef BYTE_ORDER
#define BYTE_ORDER LITTLE_ENDIAN
#endif

#define SWAPINT16(y) y = \
	( (((y)&0xff)<<8) | (((y)&0xff00)>>8) );

#define SWAPINT32(y) y = \
((((y)&0xff)<<24) | (((y)&0xff00)<<8) | (((y)&0xff0000)>>8) | (((y)>>24)&0xff));

#define FT_PDU_V1_MAXFLOWS	24	/* max records in V1 packet */
#define FT_PDU_V5_MAXFLOWS	30	/* max records in V5 packet */
#define FT_PDU_V6_MAXFLOWS	27	/* max records in V6 packet */
#define FT_PDU_V7_MAXFLOWS	27	/* max records in V7 packet */
#define FT_PDU_V8_1_MAXFLOWS	51	/* max records in V8 AS packet */
#define FT_PDU_V8_2_MAXFLOWS	51	/* max records in V8 PROTO PORT packet */
#define FT_PDU_V8_3_MAXFLOWS	44	/* max records in V8 SRC PREFIX packet */
#define FT_PDU_V8_4_MAXFLOWS	44	/* max records in V8 DST PREFIX packet */
#define FT_PDU_V8_5_MAXFLOWS	35	/* max records in V8 PREFIX packet */
#define FT_PDU_V8_6_MAXFLOWS	44	/* max records in V8 DESTONLY packet */
#define FT_PDU_V8_7_MAXFLOWS	35	/* max records in V8 SRC_DEST packet */
#define FT_PDU_V8_8_MAXFLOWS	29	/* max records in V8 FULL_FLOW packet */
#define FT_PDU_V8_9_MAXFLOWS	44	/* max records in V8 AS_TOS packet */
#define FT_PDU_V8_10_MAXFLOWS	44	/* max records in V8 PROT_PORT_TOS packet */
#define FT_PDU_V8_11_MAXFLOWS	44	/* max records in V8 SRC_PREFIX_TOS packet */
#define FT_PDU_V8_12_MAXFLOWS	44	/* max records in V8 DST_PREFIX_TOS packet */
#define FT_PDU_V8_13_MAXFLOWS	35	/* max records in V8 PREFIX_TOS packet */
#define FT_PDU_V8_14_MAXFLOWS	35	/* max records in V8 PREFIX_PORT_TOS packet */

struct pdu_header {
	u_int16_t version;	/* 1 for now. */
	u_int16_t count;		/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.)
*/
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
};

struct pdu_v1 {
	/* 16 byte header */
	u_int16_t version;	/* 1 for now. */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	/* 48 byte payload */
	struct rec_v1 {
		u_int32_t srcaddr;	/* Source IP Address */
		u_int32_t dstaddr;	/* Destination IP Address */
		u_int32_t nexthop;	/* Next hop router's IP Address */
		u_int16_t input;	/* Input interface index */
		u_int16_t output;	/* Output interface index */
		u_int32_t dPkts;	/* Packets sent in Duration */
		u_int32_t dOctets;	/* Octets sent in Duration. */
		u_int32_t First;	/* SysUptime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int16_t srcport;	/* TCP/UDP source port number or equivalent */
		u_int16_t dstport;	/* TCP/UDP destination port number or equiv */
		u_int16_t pad;
		u_int8_t  prot;	/* IP protocol, e.g., 6=TCP, 17=UDP, ... */
		u_int8_t  tos;	/* IP Type-of-Service */
		u_int8_t  flags;	/* Reason flow was discarded, etc...  */
		u_int8_t  tcp_retx_cnt;	/* Number of mis-seq with delay > 1sec */
		u_int8_t  tcp_retx_secs;	/* Cumulative secs between mis-sequenced pkts */
		u_int8_t  tcp_misseq_cnt;	/* Number of mis-sequenced tcp pkts seen */
		u_int32_t  reserved;
	} records[FT_PDU_V1_MAXFLOWS];
};

struct pdu_v5 {
	/* 24 byte header */
	u_int16_t version;	/* 5 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int16_t reserved;
	/* 48 byte payload */
	struct rec_v5 {
		u_int32_t srcaddr;	/* Source IP Address */
		u_int32_t dstaddr;	/* Destination IP Address */
		u_int32_t nexthop;	/* Next hop router's IP Address */
		u_int16_t input;	/* Input interface index */
		u_int16_t output;	/* Output interface index */
		u_int32_t dPkts;	/* Packets sent in Duration */
		u_int32_t dOctets;	/* Octets sent in Duration. */
		u_int32_t First;	/* SysUptime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int16_t srcport;	/* TCP/UDP source port number or equivalent */
		u_int16_t dstport;	/* TCP/UDP destination port number or equiv */
		u_int8_t pad;
		u_int8_t tcp_flags;	/* Cumulative OR of tcp flags */
		u_int8_t prot;	/* IP protocol, e.g., 6=TCP, 17=UDP, ... */
		u_int8_t tos;	/* IP Type-of-Service */
		u_int16_t src_as;	/* originating AS of source address */
		u_int16_t dst_as;	/* originating AS of destination address */
		u_int8_t src_mask;	/* source address prefix mask bits */
		u_int8_t dst_mask;	/* destination address prefix mask bits */
		u_int16_t drops;
	} records[FT_PDU_V5_MAXFLOWS];
};

struct pdu_v6 {
	/* 24 byte header */
	u_int16_t version;	/* 6 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int16_t reserved;
	/* 48 byte payload */
	struct rec_v6 {
		u_int32_t srcaddr;	/* Source IP Address */
		u_int32_t dstaddr;	/* Destination IP Address */
		u_int32_t nexthop;	/* Next hop router's IP Address */
		u_int16_t input;	/* Input interface index */
		u_int16_t output;	/* Output interface index */
		u_int32_t dPkts;	/* Packets sent in Duration */
		u_int32_t dOctets;	/* Octets sent in Duration. */
		u_int32_t First;	/* SysUptime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int16_t srcport;	/* TCP/UDP source port number or equivalent */
		u_int16_t dstport;	/* TCP/UDP destination port number or equiv */
		u_int8_t pad;
		u_int8_t tcp_flags;	/* Cumulative OR of tcp flags */
		u_int8_t prot;	/* IP protocol, e.g., 6=TCP, 17=UDP, ... */
		u_int8_t tos;	/* IP Type-of-Service */
		u_int16_t src_as;	/* originating AS of source address */
		u_int16_t dst_as;	/* originating AS of destination address */
		u_int8_t src_mask;	/* source address prefix mask bits */
		u_int8_t dst_mask;	/* destination address prefix mask bits */
		u_int8_t in_encaps;	/* size in bytes of the input encapsulation */
		u_int8_t out_encaps;	/* size in bytes of the output encapsulation */
		u_int32_t peer_nexthop;	/* IP address of the next hop within the peer */
	} records[FT_PDU_V6_MAXFLOWS];
};

struct pdu_v7 {
	/* 24 byte header */
	u_int16_t version;	/* 7 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int16_t reserved;
	/* 48 byte payload */
	struct rec_v7 {
		u_int32_t srcaddr;	/* Source IP Address */
		u_int32_t dstaddr;	/* Destination IP Address */
		u_int32_t nexthop;	/* Next hop router's IP Address */
		u_int16_t input;	/* Input interface index */
		u_int16_t output;	/* Output interface index */
		u_int32_t dPkts;	/* Packets sent in Duration */
		u_int32_t dOctets;	/* Octets sent in Duration. */
		u_int32_t First;	/* SysUptime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int16_t srcport;	/* TCP/UDP source port number or equivalent */
		u_int16_t dstport;	/* TCP/UDP destination port number or equiv */
		u_int8_t pad;
		u_int8_t tcp_flags;	/* Cumulative OR of tcp flags */
		u_int8_t prot;	/* IP protocol, e.g., 6=TCP, 17=UDP, ... */
		u_int8_t tos;	/* IP Type-of-Service */
		u_int16_t src_as;	/* originating AS of source address */
		u_int16_t dst_as;	/* originating AS of destination address */
		u_int8_t src_mask;	/* source address prefix mask bits */
		u_int8_t dst_mask;	/* destination address prefix mask bits */
		u_int16_t drops;
		u_int32_t router_sc;	/* Router which is shortcut by switch */
	} records[FT_PDU_V7_MAXFLOWS];
};

/* Generic v8 pdu */
struct pdu_v8_gen {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
};

struct pdu_v8_1 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 28 byte payload */
	struct rec_v8_1 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int16_t src_as;	/* originating AS of source address */
		u_int16_t dst_as;	/* originating AS of destination address */
		u_int16_t input;	/* input interface index */
		u_int16_t output;	/* output interface index */
	} records[FT_PDU_V8_1_MAXFLOWS];
};

struct pdu_v8_2 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 28 byte payload */
	struct rec_v8_2 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;	/* and of last packet of flow */
		u_int8_t prot;	/* IP protocol */
		u_int8_t pad;
		u_int16_t reserved;
		u_int16_t srcport;	/* TCP/UDP source port number of equivalent */
		u_int16_t dstport;	/* TCP/UDP dst port number of equivalent */
	} records[FT_PDU_V8_2_MAXFLOWS];
};

struct pdu_v8_3 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_3 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t src_prefix;
		u_int8_t src_mask;
		u_int8_t pad;
		u_int16_t src_as;
		u_int16_t input;
		u_int16_t reserved;
	} records[FT_PDU_V8_3_MAXFLOWS];
};

struct pdu_v8_4 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_4 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t dst_prefix;
		u_int8_t dst_mask;
		u_int8_t pad;
		u_int16_t dst_as;
		u_int16_t output;
		u_int16_t reserved;
	} records[FT_PDU_V8_4_MAXFLOWS];
};

struct pdu_v8_5 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
  /* 40 byte payload */
	struct rec_v8_5 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t src_prefix;
		u_int32_t dst_prefix;
		u_int8_t dst_mask;
		u_int8_t src_mask;
		u_int16_t reserved;
		u_int16_t src_as;
		u_int16_t dst_as;
		u_int16_t input;
		u_int16_t output;
  } records[FT_PDU_V8_5_MAXFLOWS];
};

struct pdu_v8_6 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_6 {
		u_int32_t dstaddr;	/* destination IP address */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int16_t output;	/* output interface index */
		u_int8_t tos;	/* tos */
		u_int8_t marked_tos;	/* tos of pkts that exceeded the contract */
		u_int32_t extra_pkts;	/* packets that exceed the contract */
		u_int32_t router_sc;  /* IP address of the router being shortcut */
	} records[FT_PDU_V8_6_MAXFLOWS];
};

struct pdu_v8_7 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 40 byte payload */
	struct rec_v8_7 {
		u_int32_t dstaddr;	/* destination IP address */
		u_int32_t srcaddr;	/* source address */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int16_t output;	/* output interface index */
		u_int16_t input;	/* input interface index */
		u_int8_t tos;	/* tos */
		u_int8_t marked_tos;	/* tos of pkts that exceeded the contract */
		u_int16_t reserved;
		u_int32_t extra_pkts;	/* packets that exceed the contract */
		u_int32_t router_sc;	/* IP address of the router being shortcut */
	} records[FT_PDU_V8_7_MAXFLOWS];
};

struct pdu_v8_8 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 44 byte payload */
	struct rec_v8_8 {
		u_int32_t dstaddr;	/* destination IP address */
		u_int32_t srcaddr;	/* source IP address */
		u_int16_t dstport;	/* TCP/UDP destination port */
		u_int16_t srcport;	/* TCP/UDP source port */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int16_t output;	/* output interface index */
		u_int16_t input;	/* input interface index */
		u_int8_t tos;		/* tos */
		u_int8_t prot;		/* protocol */
		u_int8_t marked_tos;	/* tos of pkts that exceeded the contract */
		u_int8_t reserved;
		u_int32_t extra_pkts;	/* packets that exceed the contract */
		u_int32_t router_sc;	/* IP address of the router being shortcut */
	} records[FT_PDU_V8_8_MAXFLOWS];
};


struct pdu_v8_9 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_9 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int16_t src_as;	/* originating AS of source address */
		u_int16_t dst_as;	/* originating AS of destination address */
		u_int16_t input;	/* input interface index */
		u_int16_t output;	/* output interface index */
		u_int8_t tos;	/* tos */
		u_int8_t pad;
		u_int16_t reserved;
	} records[FT_PDU_V8_9_MAXFLOWS];
};

struct pdu_v8_10 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_10 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int8_t prot;		/* IP protocol */
		u_int8_t tos;		/* tos */
		u_int16_t reserved;
		u_int16_t srcport;	/* TCP/UDP source port number of equivalent */
		u_int16_t dstport;	/* TCP/UDP dst port number of equivalent */
		u_int16_t input;	/* input interface */
		u_int16_t output;	/* output interface index */
	} records[FT_PDU_V8_10_MAXFLOWS];
};

struct pdu_v8_11 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_11 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t src_prefix;	/* Source Prefix */
		u_int8_t src_mask;	/* Source Prefix mask length */
		u_int8_t tos;		/* tos */
		u_int16_t src_as;	/* Source AS */
		u_int16_t input;	/* input interface */
		u_int16_t reserved;
	} records[FT_PDU_V8_11_MAXFLOWS];
};

struct pdu_v8_12 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 32 byte payload */
	struct rec_v8_12 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t dst_prefix;	/* Destination Prefix */
		u_int8_t dst_mask;	/* Destination Prefix mask length */
		u_int8_t tos;		/* tos */
		u_int16_t dst_as;	/* Destination AS */
		u_int16_t output;	/* output interface */
		u_int16_t reserved;
	} records[FT_PDU_V8_12_MAXFLOWS];
};

struct pdu_v8_13 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 40 byte payload */
	struct rec_v8_13 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t src_prefix;	/* Source Prefix */
		u_int32_t dst_prefix;	/* Destination Prefix */
		u_int8_t dst_mask;	/* Destination Prefix mask length */
		u_int8_t src_mask;	/* Source Prefix mask length */
		u_int8_t tos;		/* tos */
		u_int8_t pad;
		u_int16_t src_as;	/* Source AS */
		u_int16_t dst_as;	/* Destination AS */
		u_int16_t input;	/* input interface */
		u_int16_t output;	/* output interface */
	} records[FT_PDU_V8_13_MAXFLOWS];
};

struct pdu_v8_14 {
	/* 28 byte header */
	u_int16_t version;	/* 8 */
	u_int16_t count;	/* The number of records in the PDU */
	u_int32_t sysUpTime;	/* Current time in millisecs since router booted */
	u_int32_t unix_secs;	/* Current seconds since 0000 UTC 1970 */
	u_int32_t unix_nsecs;	/* Residual nanoseconds since 0000 UTC 1970 */
	u_int32_t flow_sequence;	/* Seq counter of total flows seen */
	u_int8_t engine_type;	/* Type of flow switching engine (RP,VIP,etc.) */
	u_int8_t engine_id;	/* Slot number of the flow switching engine */
	u_int8_t aggregation;	/* Aggregation method being used */
	u_int8_t agg_version;	/* Version of the aggregation export */
	u_int32_t reserved;
	/* 40 byte payload */
	struct rec_v8_14 {
		u_int32_t dFlows;	/* Number of flows */
		u_int32_t dPkts;	/* Packets sent in duration */
		u_int32_t dOctets;	/* Octets sent in duration */
		u_int32_t First;	/* SysUpTime at start of flow */
		u_int32_t Last;		/* and of last packet of flow */
		u_int32_t src_prefix;	/* Source Prefix */
		u_int32_t dst_prefix;	/* Destination Prefix */
		u_int8_t dst_mask;	/* Destination Prefix mask length */
		u_int8_t src_mask;	/* Source Prefix mask length */
		u_int8_t tos;		/* tos */
		u_int8_t prot;		/* protocol */
		u_int16_t srcport;	/* Source port */
		u_int16_t dstport;	/* Destination port */
		u_int16_t input;	/* input interface */
		u_int16_t output;	/* output interface */
	} records[FT_PDU_V8_14_MAXFLOWS];
};
