/*********************************************************
*  rlm_flow.h   rlm_flow - FreeRADIUS Cisco Flows Module *
*  Nikolay P. Romanyuk <mag@vtelecom.ru>                 *
**********************************************************/

#ifndef _RLM_FLOW_H
#define _RLM_FLOW_H

#if HAVE_SEMAPHORE_H
#include <semaphore.h>
#endif

#define FLOWSOCK_LOCKED		0
#define FLOWSOCK_UNLOCKED	1

typedef struct flow_socket {
	int id;
	int fd;
#if HAVE_SEMAPHORE_H
	sem_t *semaphore;
#else
	int in_use;
#endif
	enum { sockconnected, sockunconnected } state;
	struct flow_socket *next;
} FLOWSOCK;

typedef struct rlm_flow_t {
	char		*flowmuxhost;
	int		flowmuxport;
	int		num_sockets;
	int		timeout;
	FLOWSOCK	*sockpool;
	int		used;
	in_addr_t	addr;
} rlm_flow_t;

struct mppp {
	in_addr_t	addr;
	int		count;
	char		*login;
	struct mppp	*next;
};

static int flow_poolinit(rlm_flow_t *);
static void flow_poolfree(rlm_flow_t *);
static void connect_flowsock(FLOWSOCK *, rlm_flow_t *);
static void close_flowsock(FLOWSOCK *);
static in_addr_t get_fip(char *);
static FLOWSOCK *get_socket(rlm_flow_t *);
static void release_socket(FLOWSOCK *, rlm_flow_t *);
static int write_sock(FLOWSOCK *, struct cmd *);
static int read_sock(FLOWSOCK *, u_long *, rlm_flow_t *);
static int check_mppp(char *, int, in_addr_t);

#endif
