#!/usr/bin/perl -T
##########################################################################
#                                                                        #
#    acctsummarize.pl             InnerCite                              #
#                                 Mike Machado <mike@innercite.com>      #
#                                 30 March 2000                          #
#                                                                        #
#    Summarizes radacct entries older than a month into radacct_summary  #
#                                                                        #
#                   Copyright under same terms as Cistron RADIUS         #
#                                                                        #
##########################################################################
 
use DBI;
use strict;
 
my $dbusername = 'root';
my $dbpassword = 'rootpass';
 
my $dbh = DBI->connect("DBI:mysql:radius",$dbusername, $dbpassword) || die "Cound not connect to radius database as $dbusername\n";
my $sth;

my $time = getrolldate();

$sth = $dbh->do("UPDATE radacct SET AcctStartTime =  from_unixtime(unix_timestamp(AcctStopTime) - AcctSessionTime) WHERE AcctStartTime = 0");

$sth = $dbh->prepare("SELECT UserName, COUNT(RadAcctId), SUM(AcctSessionTime), SUM(AcctInputOctets), SUM(AcctOutputOctets), MIN(AcctStartTime), MAX(AcctStopTime) FROM radacct WHERE AcctStopTime < DATE_SUB('$time', INTERVAL 2 MONTH) AND AcctStopTime != 0 GROUP BY UserName");
$sth->execute;
while(my @row = $sth->fetchrow_array) {
	my $sth1 = $dbh->do("INSERT INTO radacct_summary (UserName, Sessions, PeriodStart, PeriodStop, TotalSessionTime, TotalInputOctets, TotalOutputOctets) values ('$row[0]','$row[1]','$row[5]','$row[6]','$row[2]', '$row[3]','$row[4]')");
}
$sth->finish;

$sth = $dbh->do("DELETE FROM radacct WHERE AcctStopTime < DATE_SUB('$time', INTERVAL 2 MONTH) AND AcctStopTime != 0");

$dbh->disconnect();




sub getrolldate {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
 
  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }
 
  return "$year-$nummon-01 00:00:00";
}                                                                                                                                           
