/*
 * radius.c	Miscellanous generic functions.
 *
 * Version:	@(#)radius.c  2.34  27-Apr-1999  miquels@cistron.nl
 *
 */

char misc_sccsid[] =
"@(#)radius.c 	2.34 Copyright 1998-1999 Cistron Internet Services B.V.";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>

#include	"radiusd.h"

/*RELAX start*/
u_char    rrnr[32];
u_char    rrnrpool[33];
u_char    clid_rrnr[32];
/*RELAX stop*/

/*
 *	Make sure our buffer is aligned.
 */
static int	i_send_buffer[1024];
static char	*send_buffer = (char *)i_send_buffer;

#ifdef ASCEND_SECRET
/*************************************************************************
 *
 *      Function: make_secret
 *
 *      Purpose: Build an encrypted secret value to return in a reply
 *               packet.  The secret is hidden by xoring with a MD5 digest
 *               created from the shared secret and the authentication
 *               vector.  We put them into MD5 in the reverse order from
 *               that used when encrypting passwords to RADIUS.
 *
 *************************************************************************/

void make_secret(u_char *digest, u_char *vector, u_char *secret, char *value)
{
        u_char  buffer[ AUTH_STRING_LEN ];
        int             secretLen = strlen( (const char *)secret );
        int             ix;

        memcpy( buffer, vector, AUTH_VECTOR_LEN );
        memcpy( buffer + AUTH_VECTOR_LEN, secret, secretLen );
        md5_calc( digest, buffer, AUTH_VECTOR_LEN + secretLen );
        memset( buffer, 0, AUTH_STRING_LEN );
        for ( ix = 0; ix < AUTH_VECTOR_LEN; ix += 1 ) {
                digest[ ix ] ^= value[ ix ];
        }
}
#endif /* ASCEND_SECRET */


/*
 *	Reply to the request.  Also attach
 *	reply attribute value pairs and any user message provided.
 */
int rad_send_reply(int code, AUTH_REQ *authreq, VALUE_PAIR *oreply,
			char *msg, int activefd)
{
	AUTH_HDR		*auth;
	u_short			total_length;
	struct	sockaddr	saremote;
	struct	sockaddr_in	*sin;
	u_char			*ptr, *length_ptr;
	char			*what;
	int			len;
	UINT4			lvalue;
	u_char			digest[16];
	int			secretlen;
	VALUE_PAIR		*reply;
	int			vendorcode, vendorpec;

	auth = (AUTH_HDR *)send_buffer;
	reply = oreply;

	switch(code) {
		case PW_PASSWORD_REJECT:
		case PW_AUTHENTICATION_REJECT:
			what = "Access Reject";
			/*
			 *	Also delete all reply attributes
			 *	except proxy-pair and port-message.
			 */
			reply = NULL;
			pairmove2(&reply, &oreply, PW_REPLY_MESSAGE);
			break;
		case PW_ACCESS_CHALLENGE:
			what = "Challenge";
			break;
		case PW_AUTHENTICATION_ACK:
			what = "Access Ack";
			break;
		case PW_ACCOUNTING_RESPONSE:
			what = "Accounting Ack";
			break;
		default:
			what = "Reply";
			break;
	}

	/* this could be more efficient, but it works... */

	/*	DEBUG("authreq proxy pairs contains:\n");

	fprint_attr_list(stdout,authreq->proxy_pairs); 
	*/

        /* Proxy pairs added to reply */
	pairmove2(&reply, &authreq->proxy_pairs, PW_PROXY_STATE);

	/*
	 *	Build standard header
	 */
	auth->code = code;
	auth->id = authreq->id;
	memcpy(auth->vector, authreq->vector, AUTH_VECTOR_LEN);

	DEBUG("Sending %s of id %d to %lx (nas %s)",
		what, authreq->id, (u_long)authreq->ipaddr,
		nas_name2(authreq));

	total_length = AUTH_HDR_LEN;

	/*
	 *	Load up the configuration values for the user
	 */
	ptr = auth->data;
	while(reply != (VALUE_PAIR *)NULL) {
		debug_pair(stdout, reply);

		/*
		 *	This could be a vendor-specific attribute.
		 */
		length_ptr = NULL;
		if ((vendorcode = VENDOR(reply->attribute)) > 0 &&
		    (vendorpec  = dict_vendorpec(vendorcode)) > 0) {
			*ptr++ = PW_VENDOR_SPECIFIC;
			length_ptr = ptr;
			*ptr++ = 6;
			lvalue = htonl(vendorpec);
			memcpy(ptr, &lvalue, 4);
			ptr += 4;
			total_length += 6;
		} else if (reply->attribute > 0xff) {
			/*
			 *	Ignore attributes > 0xff
			 */
			reply = reply->next;
			continue;
		} else
			vendorpec = 0;

#ifdef ATTRIB_NMC
		if (vendorpec == VENDORPEC_USR) {
			lvalue = htonl(reply->attribute & 0xFFFF);
			memcpy(ptr, &lvalue, 4);
			total_length += 2;
			*length_ptr  += 2;
			ptr          += 4;
		} else
#endif
		*ptr++ = (reply->attribute & 0xFF);

		switch(reply->type) {

		case PW_TYPE_STRING:
			/*
			* This is to hash the Ascend-Send-Secret before
			* we send it to the Max.
			*/
#ifdef ASCEND_SECRET
			if (( strcmp(reply->name, "Ascend-Send-Secret") == 0 )
			|| ( strcmp(reply->name, "Ascend-Recv-Secret") == 0 )) {
				make_secret( digest, authreq->vector,
				authreq->secret, reply->strvalue );
				*ptr++ = AUTH_VECTOR_LEN + 2;
				memcpy( ptr, digest, AUTH_VECTOR_LEN );
				ptr += AUTH_VECTOR_LEN;
				total_length += AUTH_VECTOR_LEN + 2;
				break;
			}
#endif	/* ASCEND_SECRET */

			/*
			 *	FIXME: this is just to make sure but
			 *	should NOT be needed. In fact I have no
			 *	idea if it is needed :)
			 */

			/*RELAX start*/
			if (strcmp(reply->name,"Ascend-Dial-Number")== 0
				&&rrnr[0]!='\0')
			{
				sprintf(rrnrpool,"9%s",rrnr);
				strcpy(reply->name,"pusegn");
				strcpy(reply->strvalue,rrnrpool);
				reply->length = strlen(reply->strvalue);
			}
			/*RELAX stop */

			if (reply->length == 0 && reply->strvalue[0] != 0)
				reply->length = strlen(reply->strvalue);

			len = reply->length;
			if (len >= AUTH_STRING_LEN) {
				len = AUTH_STRING_LEN - 1;
			}
#ifdef ATTRIB_NMC
			if (vendorpec != VENDORPEC_USR)
#endif
				*ptr++ = len + 2;
			if (length_ptr) *length_ptr += len + 2;
			memcpy(ptr, reply->strvalue,len);
			ptr += len;
			total_length += len + 2;
			break;

		case PW_TYPE_INTEGER:
		case PW_TYPE_IPADDR:
#ifdef ATTRIB_NMC
			if (vendorpec != VENDORPEC_USR)
#endif
				*ptr++ = sizeof(UINT4) + 2;
			if (length_ptr) *length_ptr += sizeof(UINT4)+ 2;
			lvalue = htonl(reply->lvalue);
			memcpy(ptr, &lvalue, sizeof(UINT4));
			ptr += sizeof(UINT4);
			total_length += sizeof(UINT4) + 2;
			break;

#if defined( BINARY_FILTERS )
		case PW_TYPE_FILTER_BINARY:
			/* The binary representation of the filter is in
			reply->strvalue.  It's length is in reply->lvalue */

			*ptr++ = reply->lvalue + 2;
			memcpy( ptr, reply->strvalue, reply->lvalue );
			ptr += reply->lvalue;
			total_length += reply->lvalue + 2;
			break;
#endif	/* BINARY_FILTERS */

		default:
			break;
		}

		reply = reply->next;
	}

	/*
	 *	Append the user message
	 *	FIXME: add multiple PW_REPLY_MESSAGEs if it
	 *	doesn't fit into one.
	 */
	if(msg != NULL) {
		len = strlen(msg);
		if (len > 0 && len < AUTH_STRING_LEN) {
			*ptr++ = PW_REPLY_MESSAGE;
			*ptr++ = len + 2;
			memcpy(ptr, msg, len);
			ptr += len;
			total_length += len + 2;
		}
	}

	auth->length = htons(total_length);

	/*
	 *	Append secret and calculate the response digest
	 */
	secretlen = strlen(authreq->secret);
	memcpy(send_buffer + total_length, authreq->secret, secretlen);
	md5_calc(digest, (char *)auth, total_length + secretlen);
	memcpy(auth->vector, digest, AUTH_VECTOR_LEN);
	memset(send_buffer + total_length, 0, secretlen);

	sin = (struct sockaddr_in *) &saremote;
        memset ((char *) sin, '\0', sizeof (saremote));
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = htonl(authreq->ipaddr);
	sin->sin_port = htons(authreq->udp_port);

	/*
	 *	Send it to the user
	 */
	sendto(activefd, (char *)auth, (int)total_length, (int)0,
			&saremote, sizeof(struct sockaddr_in));

	/*
	 *	Just to be tidy move pairs back.
	 */
	if (reply != oreply) {
		pairmove2(&oreply, &reply, PW_PROXY_STATE);
		pairmove2(&oreply, &reply, PW_REPLY_MESSAGE);
	}

	return 0;
}

/*
 *	Validates the requesting client NAS.  Calculates the
 *	digest to be used for decrypting the users password
 *	based on the clients private key.
 */
int calc_digest(u_char *digest, AUTH_REQ *authreq)
{
	u_char	buffer[128];
	int	secretlen;
	CLIENT	*cl;

	/*
	 *	See if we know this client.
	 */
	if ((cl = client_find(authreq->ipaddr)) == NULL) {
		log(L_ERR, "request from unknown client: %s",
			client_name(authreq->ipaddr));
		return -1;
	}

	/*
	 *	Use the secret to setup the decryption digest
	 */
	secretlen = strlen(cl->secret);
	strNcpy(buffer, cl->secret, sizeof(buffer));
	memcpy(buffer + secretlen, authreq->vector, AUTH_VECTOR_LEN);
	md5_calc(digest, buffer, secretlen + AUTH_VECTOR_LEN);
	strNcpy(authreq->secret, cl->secret, sizeof(authreq->secret));
	memset(buffer, 0, sizeof(buffer));

	return(0);
}

/*
 *	Validates the requesting client NAS.  Calculates the
 *	signature based on the clients private key.
 */
int calc_acctdigest(u_char *digest, AUTH_REQ *authreq)
{
	int	secretlen;
	CLIENT	*cl;
	char zero[AUTH_VECTOR_LEN];
	char	* recvbuf = authreq->data;
	int	len = authreq->data_len;

	/*
	 *	See if we know this client.
	 */
	if ((cl = client_find(authreq->ipaddr)) == NULL) {
		log(L_ERR, "request from unknown client: %s",
			client_name(authreq->ipaddr));
		return -1;
	}

	/*
	 *	Copy secret into authreq->secret so that we can
	 *	use it with send_acct_reply()
	 */
	secretlen = strlen(cl->secret);
	strNcpy(authreq->secret, cl->secret, sizeof(authreq->secret));

	/*
	 *	Older clients have the authentication vector set to
	 *	all zeros. Return `1' in that case.
	 */
	memset(zero, 0, sizeof(zero));
	if (memcmp(authreq->vector, zero, AUTH_VECTOR_LEN) == 0)
		return 1;

	/*
	 *	Zero out the auth_vector in the received packet.
	 *	Then append the shared secret to the received packet,
	 *	and calculate the MD5 sum. This must be the same
	 *	as the original MD5 sum (authreq->vector).
	 */
	memset(recvbuf + 4, 0, AUTH_VECTOR_LEN);
	memcpy(recvbuf + len, cl->secret, secretlen);
	md5_calc(digest, recvbuf, len + secretlen);

	/*
	 *	Return 0 if OK, 2 if not OK.
	 */
	return memcmp(digest, authreq->vector, AUTH_VECTOR_LEN) ? 2 : 0;
}

/*
 *	Receive UDP client requests, build an authorization request
 *	structure, and attach attribute-value pairs contained in
 *	the request to the new structure.
 */
AUTH_REQ	*radrecv(UINT4 host, u_short udp_port,
			u_char *buffer, int length)
{
	u_char		*ptr;
	AUTH_HDR	*auth;
	char		*what;
	int		totallen;
	int		attribute;
	int		attrlen;
	int		vendorlen;
	DICT_ATTR	*attr;
	UINT4		lvalue;
	UINT4		vendorcode;
	UINT4		vendorpec;
	VALUE_PAIR	*first_pair;
	VALUE_PAIR	*prev;
	VALUE_PAIR	*pair;
	AUTH_REQ	*authreq;

	/*
	 *	Pre-allocate the new request data structure
	 */

	if((authreq = (AUTH_REQ *)malloc(sizeof(AUTH_REQ))) ==
						(AUTH_REQ *)NULL) {
		log(L_ERR|L_CONS, "no memory");
		exit(1);
	}
	memset(authreq, 0, sizeof(AUTH_REQ));

	auth = (AUTH_HDR *)buffer;
	totallen = ntohs(auth->length);
	if (length > totallen) length = totallen;


	switch(auth->code) {
		case PW_AUTHENTICATION_REQUEST:
			what = "Access Request";
			break;
		case PW_ACCOUNTING_REQUEST:
			what = "Accounting Request";
			break;
		case PW_ACCOUNTING_RESPONSE:
			what = "Accounting Response";
			break;
		case PW_AUTHENTICATION_ACK:
			what = "Access Ack";
			break;
		case PW_AUTHENTICATION_REJECT:
			what = "Access Reject";
			break;
		default:
			what = "Request";
			break;
	}
		
	DEBUG("radrecv: %s from host %lx code=%d, id=%d, length=%d",
				what, (u_long)host, auth->code, auth->id, totallen);

	/*
	 *	Fill header fields
	 */
	authreq->ipaddr = host;
	authreq->udp_port = udp_port;
	authreq->id = auth->id;
	authreq->code = auth->code;
	memcpy(authreq->vector, auth->vector, AUTH_VECTOR_LEN);
	authreq->data = buffer;
	authreq->data_len = length;
	authreq->proxy_pairs = NULL;
	authreq->server_reply = NULL;

	/*
	 *	Extract attribute-value pairs
	 */
	ptr = auth->data;
	length -= AUTH_HDR_LEN;
	first_pair = (VALUE_PAIR *)NULL;
	prev = (VALUE_PAIR *)NULL;

	vendorcode = 0;
	vendorlen  = 0;

	while(length > 0) {

		if (vendorlen > 0) {
			attribute = *ptr++ | (vendorcode << 16);
			attrlen   = *ptr++;
		} else {
			attribute = *ptr++;
			attrlen   = *ptr++;
		}
		if (attrlen < 2) {
			length = 0;
			continue;
		}
		attrlen -= 2;
		length  -= 2;

		/*
		 *	This could be a Vendor-Specific attribute.
		 *
		 */
		if (vendorlen <= 0 &&
		    attribute == PW_VENDOR_SPECIFIC && attrlen > 6) {
			memcpy(&lvalue, ptr, 4);
			vendorpec = ntohl(lvalue);
			if ((vendorcode = dict_vendorcode(vendorpec))
			    != 0) {
#ifdef ATTRIB_NMC
				if (vendorpec == VENDORPEC_USR) {
					ptr += 4;
					memcpy(&lvalue, ptr, 4);
					/*printf("received USR %04x\n", ntohl(lvalue));*/
					attribute = (ntohl(lvalue) & 0xFFFF) |
							(vendorcode << 16);
					ptr += 4;
					attrlen -= 8;
					length -= 8;
				} else
#endif
				{
					ptr += 4;
					vendorlen = attrlen - 4;
					attribute = *ptr++ | (vendorcode << 16);
					attrlen   = *ptr++;
					attrlen -= 2;
					length -= 6;
				}
			}
		}

		if ((pair = (VALUE_PAIR *)malloc(sizeof(VALUE_PAIR))) == (VALUE_PAIR *)NULL) {
			log(L_ERR|L_CONS, "no memory");
			exit(1);
		}
		memset(pair, 0, sizeof(VALUE_PAIR));

		if ((attr = dict_attrget(attribute)) == (DICT_ATTR *)NULL) {
			sprintf(pair->name, "Unknown-Attr-%d", attribute);
			pair->type = PW_TYPE_STRING;
		} else {
			strcpy(pair->name, attr->name);
			pair->type = attr->type;
		}

		if ( attrlen >= AUTH_STRING_LEN-1 ) {
			DEBUG("attribute %d too long, %d >= %d", attribute,
				attrlen, AUTH_STRING_LEN);
			free(pair);
		}
		else if ( attrlen > length ) {
			DEBUG("attribute %d longer as buffer left, %d > %d",
				attribute, attrlen, length);
			free(pair);
		}
		else {
			pair->attribute = attribute;
			pair->length = attrlen;
			pair->next = (VALUE_PAIR *)NULL;
			pair->operator = PW_OPERATOR_EQUAL;
			pair->strvalue[0] = '\0';

			switch (pair->type) {

			case PW_TYPE_STRING:
				/* attrlen always < AUTH_STRING_LEN */
				memset(pair->strvalue, 0, AUTH_STRING_LEN);
				memcpy(pair->strvalue, ptr, attrlen);
				debug_pair(stdout, pair);

				if(first_pair == (VALUE_PAIR *)NULL) {
					first_pair = pair;
				}
				else {
					prev->next = pair;
				}
				prev = pair;
				break;
			
			case PW_TYPE_INTEGER:
			case PW_TYPE_IPADDR:
				memcpy(&lvalue, ptr, sizeof(UINT4));
				pair->lvalue = ntohl(lvalue);
				debug_pair(stdout, pair);
				if(first_pair == (VALUE_PAIR *)NULL) {
					first_pair = pair;
				}
				else {
					prev->next = pair;
				}
				prev = pair;
				break;

#if defined( BINARY_FILTERS )
			case PW_TYPE_FILTER_BINARY:
				memcpy(pair->strvalue, ptr, attrlen);
				pair->strvalue[attrlen] = '\0';
				if(first_pair == (VALUE_PAIR *)NULL) {
					first_pair = pair;
				}
				else {
					prev->next = pair;
				}
				prev = pair;
 				break;
#endif	/* BINARY_FILTERS */
			
			default:
				DEBUG("    %s (Unknown Type %d)",
					pair->name,pair->type);
				free(pair);
				break;
			}

		}
		ptr += attrlen;
		length -= attrlen;
		if (vendorlen > 0) vendorlen -= (attrlen + 2);
	}
	authreq->request = first_pair;


        /* hide the proxy pairs from the rest of the server */
        pairmove2(&authreq->proxy_pairs, &authreq->request, PW_PROXY_STATE);

	/*
	 *      Create a Client-IP-Address attribute, and add it to the
	 *      user's request.
	 */
	if ((pair = malloc(sizeof(VALUE_PAIR))) == NULL) {
		log(L_CONS|L_ERR, "no memory");
		exit(1);
	}
	memset(pair, 0, sizeof(VALUE_PAIR));
	strcpy(pair->name, "Client-IP-Address");
	pair->attribute = PW_CLIENT_IP_ADDRESS;
	pair->type = PW_TYPE_IPADDR;
	pair->lvalue = host;
	pairadd(&authreq->request, pair);

	return(authreq);
}


#if 0 /* Not used anymore */
/*
 *	Reply to the request with a CHALLENGE.  Also attach
 *	any user message provided and a state value.
 */
static void send_challenge(AUTH_REQ *authreq, char *msg,
				char *state, int activefd)
{
	AUTH_HDR		*auth;
	struct	sockaddr	saremote;
	struct	sockaddr_in	*sin;
	char			digest[AUTH_VECTOR_LEN];
	int			secretlen;
	int			total_length;
	u_char			*ptr;
	int			len;

	auth = (AUTH_HDR *)send_buffer;

	/*
	 *	Build standard response header
	 */
	auth->code = PW_ACCESS_CHALLENGE;
	auth->id = authreq->id;
	memcpy(auth->vector, authreq->vector, AUTH_VECTOR_LEN);
	total_length = AUTH_HDR_LEN;

	/*
	 *	Append the user message
	 */
	if (msg != (char *)NULL) {
		len = strlen(msg);
		if(len > 0 && len < AUTH_STRING_LEN-1) {
			ptr = auth->data;
			*ptr++ = PW_REPLY_MESSAGE;
			*ptr++ = len + 2;
			memcpy(ptr, msg, len);
			ptr += len;
			total_length += len + 2;
		}
	}

	/*
	 *	Append the state info
	 */
	if((state != (char *)NULL) && (strlen(state) > 0)) {
		len = strlen(state);
		*ptr++ = PW_STATE;
		*ptr++ = len + 2;
		memcpy(ptr, state, len);
		ptr += len;
		total_length += len + 2;
	}

	/*
	 *	Set total length in the header
	 */
	auth->length = htons(total_length);

	/*
	 *	Calculate the response digest
	 */
	secretlen = strlen(authreq->secret);
	memcpy(send_buffer + total_length, authreq->secret, secretlen);
	md5_calc(digest, (char *)auth, total_length + secretlen);
	memcpy(auth->vector, digest, AUTH_VECTOR_LEN);
	memset(send_buffer + total_length, 0, secretlen);

	sin = (struct sockaddr_in *) &saremote;
        memset ((char *) sin, '\0', sizeof (saremote));
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = htonl(authreq->ipaddr);
	sin->sin_port = htons(authreq->udp_port);

	DEBUG("Sending Challenge of id %d to %lx (nas %s)",
		authreq->id, (u_long)authreq->ipaddr,
		nas_name2(authreq));
	
	/*
	 *	Send it to the user
	 */
	sendto(activefd, (char *)auth, (int)total_length, (int)0,
			&saremote, sizeof(struct sockaddr_in));
}
#endif
