/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

/*
 *	@(#)radius.h	2.0  03-Aug-1996
 */

#define AUTH_VECTOR_LEN		16
#define AUTH_PASS_LEN		16
#define AUTH_STRING_LEN		254	/* maximum of 254 */


typedef struct pw_auth_hdr {
	u_char		code;
	u_char		id;
	u_short		length;
	u_char		vector[AUTH_VECTOR_LEN];
	u_char		data[2];
} AUTH_HDR;

#define AUTH_HDR_LEN			20
#define CHAP_VALUE_LENGTH		16

#define PW_AUTH_UDP_PORT		1645
#define PW_ACCT_UDP_PORT		1646

#define VENDORPEC_USR			429

#define PW_TYPE_STRING			0
#define PW_TYPE_INTEGER			1
#define PW_TYPE_IPADDR			2
#define PW_TYPE_DATE			3

#if defined( BINARY_FILTERS )
#define PW_TYPE_FILTER_BINARY		4       /* ASCEND extension */
#endif	/* BINARY_FILTERS */

#define PW_VP_USERDATA			1
#define PW_VP_GROUPDATA			2
#define PW_VP_REALMDATA			3
#define PW_VP_HINTSDATA			4

#define	PW_AUTHENTICATION_REQUEST	1
#define	PW_AUTHENTICATION_ACK		2
#define	PW_AUTHENTICATION_REJECT	3
#define	PW_ACCOUNTING_REQUEST		4
#define	PW_ACCOUNTING_RESPONSE		5
#define	PW_ACCOUNTING_STATUS		6
#define PW_PASSWORD_REQUEST		7
#define PW_PASSWORD_ACK			8
#define PW_PASSWORD_REJECT		9
#define	PW_ACCOUNTING_MESSAGE		10
#define PW_ACCESS_CHALLENGE		11

#define	PW_USER_NAME			1
#define	PW_PASSWORD			2
#define	PW_CHAP_PASSWORD		3
#define	PW_NAS_IP_ADDRESS		4
#define	PW_NAS_PORT_ID			5
#define	PW_SERVICE_TYPE			6
#define	PW_FRAMED_PROTOCOL		7
#define	PW_FRAMED_IP_ADDRESS		8
#define	PW_FRAMED_IP_NETMASK		9
#define	PW_FRAMED_ROUTING		10
#define	PW_FILTER_ID			11
#define	PW_FRAMED_MTU			12
#define	PW_FRAMED_COMPRESSION		13
#define	PW_LOGIN_IP_HOST		14
#define	PW_LOGIN_SERVICE		15
#define	PW_LOGIN_TCP_PORT		16
#define PW_OLD_PASSWORD			17
#define PW_REPLY_MESSAGE		18
#define PW_CALLBACK_NUMBER		19
#define PW_CALLBACK_ID			20
#define PW_EXPIRATION			21
#define PW_FRAMED_ROUTE			22
#define PW_FRAMED_IPXNET		23
#define PW_STATE			24
#define PW_CLASS			25
#define PW_VENDOR_SPECIFIC		26
#define PW_SESSION_TIMEOUT		27
#define PW_IDLE_TIMEOUT			28
#define PW_CALLED_STATION_ID		30
#define PW_CALLING_STATION_ID		31
#define PW_PROXY_STATE			33

#define PW_ACCT_STATUS_TYPE		40
#define PW_ACCT_DELAY_TIME		41
#define PW_ACCT_INPUT_OCTETS		42
#define PW_ACCT_OUTPUT_OCTETS		43
#define PW_ACCT_SESSION_ID		44
#define PW_ACCT_AUTHENTIC		45
#define PW_ACCT_SESSION_TIME		46
#define PW_ACCT_INPUT_PACKETS		47
#define PW_ACCT_OUTPUT_PACKETS		48
#define PW_ACCT_TERMINATE_CAUSE	49

#define PW_CHAP_CHALLENGE		60
#define PW_NAS_PORT_TYPE		61
#define PW_PORT_LIMIT			62
#define PW_CONNECT_INFO			77

#define PW_RADIUS_OPERATOR		100

#define PW_FALL_THROUGH			500
#define PW_ADD_PORT_TO_IP_ADDRESS	501
#define PW_EXEC_PROGRAM			502
#define PW_EXEC_PROGRAM_WAIT		503

#define PW_HUNTGROUP_NAME		1031
#define PW_AUTHTYPE			1000
#define PW_PREFIX			1003
#define PW_SUFFIX			1004
#define PW_GROUP			1005
#define PW_CRYPT_PASSWORD		1006
#define PW_CONNECT_RATE			1007
#define PW_USER_CATEGORY		1029
#define PW_GROUP_NAME			1030
#define PW_SIMULTANEOUS_USE		1034
#define PW_STRIP_USERNAME		1035
#define PW_HINT				1040
#define PAM_AUTH_ATTR			1041
#define PW_LOGIN_TIME			1042
#define PW_REALM			1045
#define PW_CLIENT_IP_ADDRESS		1052

#define PW_MAX_HOURS			2001
#define PW_MONTHLY_TIME_LIMIT		2002
#define PW_TOTAL_TIME_LIMIT		2003
#define PW_ACTIVATION			2004
#define PW_DAILY_TIME_LIMIT		2005
#define PW_WEEKLY_TIME_LIMIT		2006


/*
 *	INTEGER TRANSLATIONS
 */

/*	USER TYPES	*/

#define	PW_LOGIN_USER			1
#define	PW_FRAMED_USER			2
#define	PW_DIALBACK_LOGIN_USER		3
#define	PW_DIALBACK_FRAMED_USER		4

/*	FRAMED PROTOCOLS	*/

#define	PW_PPP				1
#define	PW_SLIP				2

/*	FRAMED ROUTING VALUES	*/

#define	PW_NONE				0
#define	PW_BROADCAST			1
#define	PW_LISTEN			2
#define	PW_BROADCAST_LISTEN		3

/*	FRAMED COMPRESSION TYPES	*/

#define	PW_VAN_JACOBSEN_TCP_IP		1

/*	LOGIN SERVICES	*/

#define	PW_TELNET			0
#define	PW_RLOGIN			1
#define	PW_TCP_CLEAR			2
#define	PW_PORTMASTER			3

/*	AUTHENTICATION LEVEL	*/

#define PW_AUTHTYPE_LOCAL		0
#define PW_AUTHTYPE_SYSTEM		1
#define PW_AUTHTYPE_SECURID		2
#define PW_AUTHTYPE_CRYPT		3
#define PW_AUTHTYPE_REJECT		4
#define PW_AUTHTYPE_MYSQL		252
#define PW_AUTHTYPE_PAM			253
#define PW_AUTHTYPE_ACCEPT		254

/*	PORT TYPES		*/
#define PW_NAS_PORT_ASYNC		0
#define PW_NAS_PORT_SYNC		1
#define PW_NAS_PORT_ISDN		2
#define PW_NAS_PORT_ISDN_V120		3
#define PW_NAS_PORT_ISDN_V110		4

/*	STATUS TYPES	*/

#define PW_STATUS_START			1
#define PW_STATUS_STOP			2
#define PW_STATUS_ALIVE			3
#define PW_STATUS_ACCOUNTING_ON		7
#define PW_STATUS_ACCOUNTING_OFF	8

#define PW_AUTHENTICATION_REQUEST	1
#define PW_STATUS_ACCOUNTING_ON		7
#define PW_STATUS_ACCOUNTING_OFF	8

#if defined( BINARY_FILTERS )
/*
 * ASCEND extensions for ABINARY filters
 */

#define IPX_NODE_ADDR_LEN		6

typedef UINT4                 IpxNet;
typedef char                  IpxNode[ IPX_NODE_ADDR_LEN ];
typedef unsigned short        IpxSocket;

#if ! defined( FALSE )
# define FALSE                0
# define TRUE         (! FALSE)
#endif

/*
 * Two types of filters are supported, GENERIC and IP.  The identifiers
 * are:
 */

#define RAD_FILTER_GENERIC		0
#define RAD_FILTER_IP			1
#define RAD_FILTER_IPX			2

/*
 * Generic filters mask and match up to RAD_MAX_FILTER_LEN bytes
 * starting at some offset.  The length is:
 */
#define RAD_MAX_FILTER_LEN		6

/*
 * RadFilterComparison:
 *
 * An enumerated values for the IP filter port comparisons.
 */
typedef enum {
      RAD_NO_COMPARE,
      RAD_COMPARE_LESS,
      RAD_COMPARE_EQUAL,
      RAD_COMPARE_GREATER,
      RAD_COMPARE_NOT_EQUAL
} RadFilterComparison;

    /*
     * RadIpFilter:
     *
     * The binary format of an IP filter.  ALL fields are stored in
     * network byte order.
     *
     *        srcip:          The source IP address.
     *
     *        dstip:          The destination IP address.
     *
     *        srcmask:        The number of leading one bits in the source address
     *                        mask.  Specifies the bits of interest.
     *
     *        dstmask:        The number of leading one bits in the destination
     *                        address mask. Specifies the bits of interest.
     *
     *        proto:          The IP protocol number
     *
     *        establised:     A boolean value.  TRUE when we care about the
     *                        established state of a TCP connection.  FALSE when
     *                        we dont care.
     *
     *        srcport:        TCP or UDP source port number.
     *
     *        dstport:        TCP or UDP destination port number.
     *
     *        srcPortCmp:     One of the values of the RadFilterComparison enumeration
     *                        specifying how to compare the srcport value.
     *
     *        dstPortCmp:     One of the values of the RadFilterComparison enumeration
     *                        specifying how to compare the dstport value.
     *
     *        fill:           Round things out to a dword boundary.
     */
typedef struct radip {
    UINT4             srcip;
    UINT4             dstip;
    unsigned char     srcmask;
    unsigned char     dstmask;
    unsigned char     proto;
    unsigned char     established;
    unsigned short    srcport;
    unsigned short    dstport;
    unsigned char     srcPortComp;
    unsigned char     dstPortComp;
    unsigned char       fill[4];        /* used to be fill[2] */
} RadIpFilter;

    /*
     * RadIpxFilter:
     * The binary format of a GENERIC filter.  ALL fields are stored in
     * network byte order.
     *
     *  srcIpxNet:      Source IPX Net address
     *
     *  srcIpxNode:     Source IPX Node address
     *
     *  srcIpxSoc:      Source IPX socket address
     *
     *  dstIpxNet:      Destination IPX Net address
     *
     *  dstIpxNode:     Destination IPX Node address
     *
     *  dstIpxSoc:      Destination IPX socket address
     *
     *  srcSocComp:     Source socket compare value
     *
     *  dstSocComp:     Destination socket compare value
     *
     */
typedef struct radipx {
    IpxNet              srcIpxNet;                      /* LongWord */
    IpxNode             srcIpxNode;                     /* Byte[6] */
    IpxSocket           srcIpxSoc;                      /* Word */
    IpxNet              dstIpxNet;                      /* LongWord */
    IpxNode             dstIpxNode;                     /* Byte[6] */
    IpxSocket           dstIpxSoc;                      /* Word */
    unsigned char       srcSocComp;
    unsigned char       dstSocComp;
} RadIpxFilter;

    /*
     * RadGenericFilter:
     *
     * The binary format of a GENERIC filter.  ALL fields are stored in
     * network byte order.
     *
     *        offset:         Number of bytes into packet to start comparison.
     *
     *        len:            Number of bytes to mask and compare.  May not
     *                        exceed RAD_MAX_FILTER_LEN.
     *
     *        more:           Boolean.  If non-zero the next filter entry is
     *                        also to be applied to a packet.
     *
     *        mask:           A bit mask specifying the bits to compare.
     *
     *        value:          A value to compare against the masked bits at
     *                        offset in a users packet.
     *
     *        compNeq:        Defines type of comarison (Equal or Notequal)
     *                        default is Equal.
     *
     *        fill:           Round things out to a dword boundary
     */
typedef struct radgeneric {
    unsigned short    offset;
    unsigned short    len;
    unsigned short    more;
    unsigned char     mask[ RAD_MAX_FILTER_LEN ];
    unsigned char     value[ RAD_MAX_FILTER_LEN ];
    unsigned char     compNeq;
    unsigned char       fill[3];        /* used to be fill */
} RadGenericFilter;

    /*
     * RadFilter:
     *
     * A binary filter element.  Contains either a RadIpFilter or a
     * RadGenericFilter.  All fields are stored in network byte order.
     *
     *        type:           Either RAD_FILTER_GENERIC or RAD_FILTER_IP.
     *
     *        forward:        TRUE if we should forward packets that match this
     *                        filter, FALSE if we should drop packets that match
     *                        this filter.
     *
     *        indirection:    TRUE if this is an input filter, FALSE if this is
     *                        an output filter.
     *
     *        fill:           Round things out to a dword boundary.
     *
     *        u:              A union of
     *                        ip:             An ip filter entry
     *                        generic:        A generic filter entry
     */
typedef struct filter {
    unsigned char     type;
    unsigned char     forward;
    unsigned char     indirection;
    unsigned char     fill;
    union {
      RadIpFilter      ip;
      RadIpxFilter     ipx;
      RadGenericFilter generic;
    } u;
} RadFilter;
#endif	/* BINARY_FILTERS */
