/*
 * sql_module.h - MySQL header for FreeRADIUS SQL module
 *
 * Mike Machado <mike@innercite.com>
 */

#include	<mysql/mysql.h>
#include 	"conf.h"

typedef MYSQL_ROW	SQL_ROW;

typedef struct sql_config {
        char mysql_server[40];
        char mysql_login[20];
        char mysql_password[20];
        char mysql_db[20];
        char mysql_acct_table[MAX_TABLE_LEN];
        char mysql_authcheck_table[MAX_TABLE_LEN];
        char mysql_authreply_table[MAX_TABLE_LEN];
        char mysql_groupcheck_table[MAX_TABLE_LEN];
        char mysql_groupreply_table[MAX_TABLE_LEN];
        char mysql_usergroup_table[MAX_TABLE_LEN];
        char mysql_realm_table[MAX_TABLE_LEN];
        char mysql_realmgroup_table[MAX_TABLE_LEN];
        char mysql_nas_table[MAX_TABLE_LEN];
        char mysql_dict_table[MAX_TABLE_LEN];
        int  sensitiveusername;
        int  sqltrace;
	int  deletestalesessions;
	int  max_sql_socks;
} SQL_CONFIG;
 
typedef struct sql_socket {
	MYSQL		*sock;
	MYSQL		conn;
        MYSQL_RES	*result;
        int             id;
        int             in_use;
} SQLSOCK;
 
typedef struct sql {
        SQL_CONFIG *config;
        SQLSOCK *socks[MAX_SQL_SOCKS];
} SQL;


int sql_init_socket(int reload);
SQLSOCK *sql_create_socket(void);
int sql_close_socket(SQLSOCK *socket);
int sql_checksocket(const char *facility);
int sql_query(SQLSOCK *socket, char *querystr);
int sql_select_query(SQLSOCK *socket, char *querystr);
int sql_store_result(SQLSOCK *socket);
int sql_num_fields(SQLSOCK *socket);
int sql_num_rows(SQLSOCK *socket);
SQL_ROW sql_fetch_row(SQLSOCK *socket);
void sql_free_result(SQLSOCK *socket);
char *sql_error(SQLSOCK *socket);
void sql_close(SQLSOCK *socket);
void sql_finish_query(SQLSOCK *socket);
void sql_finish_select_query(SQLSOCK *socket);
int sql_affected_rows(SQLSOCK *socket);
int sql_escape_string(char *to, char *from, int length);
