/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

char attrprint_sccsid[] =
"@(#)attrprint.c	1.3 Copyright 1992 Livingston Enterprises Inc\n"
"			2.1 Copyright 1998 Cistron Internet Services B.V.";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>

#include	"radiusd.h"


/*
 *	Print the Attribute-value pair to the desired File.
 *	FIXME: work with logging routines in log.c
 */
void debug_pair(FILE *fd, VALUE_PAIR *pair)
{
	if(debug_flag) {
		fputs("    ", fd);
		fprint_attr_val(fd, pair);
		fputs("\n", fd);
	}
}


/*
 *	Write a whole list of A/V pairs.
 */
void fprint_attr_list(FILE *fd, VALUE_PAIR *pair)
{
	while(pair) {
		fprintf(fd, "    ");
		fprint_attr_val(fd, pair);
		fprintf(fd, "\n");
		pair = pair->next;
	}
}


/*
 *	Write a printable version of the attribute-value
 *	pair to the supplied File.
 */
void fprint_attr_val(FILE *fd, VALUE_PAIR *pair)
{
	DICT_VALUE	*dict_valget();
	DICT_VALUE	*dval;
	char		buffer[32];
	u_char		*ptr;
	UINT4		vendor;
	int		left;
#ifdef MULTIVALUED_VSA
	int		i;
#endif

	switch(pair->type) {

	case PW_TYPE_STRING:
		fprintf(fd, "%s = \"", pair->name);
		ptr = (u_char *)pair->strvalue;
		if (pair->attribute != PW_VENDOR_SPECIFIC) {
			left = pair->length;
			while(left-- > 0) {
				/*
				 *	Ugh! Ascend gear sends "foo"
				 *	as "foo\0", length 4.
				 *	Suppress trailing zeros.
				 */
				if (left == 0 && *ptr == 0)
					break;
				if(!(isprint(*ptr)))
					fprintf(fd, "\\%03o", *ptr);
				else
					fputc(*ptr, fd);
				ptr++;
			}
			fputc('"', fd);
			break;
		}
		/*
		 *	Special format, print out as much
		 *	info as we can.
		 */
		if (pair->length < 6) {
			fprintf(fd, "(invalid length: %d)\"", pair->length);
			break;
		}
		memcpy(&vendor, ptr, 4);
		ptr += 4;
		fprintf(fd, "V%d", (int)ntohl(vendor));
		left = pair->length - 4;
#if defined (MULTIVALUED_VSA)
		while (left >= 2) {
			fprintf(fd, ":T%d:L%d:", ptr[0], ptr[1]);
			left -= 2;
			ptr += 2;
			i = ptr[1] - 2;
			while (i > 0 && left > 0) {
				if(!(isprint(*ptr)))
					fprintf(fd, "\\%03o", *ptr);
				else
					fputc(*ptr, fd);
				ptr++;
				i--;
				left--;
			}
		}
#else
		fprintf(fd, ":T%d:L%d:", ptr[0], ptr[1]);
		left -= 2;
		ptr += 2;
		while(left > 0) {
		  fprintf(fd, "%02x", *ptr);
		  ptr++;
		  left--;
		}
#endif /*MULTIVALUED_VSA*/		
		fputc('"', fd);
		break;

	case PW_TYPE_INTEGER:
		dval = dict_valget(pair->lvalue, pair->name);
		if(dval != (DICT_VALUE *)NULL) {
			fprintf(fd, "%s = %s", pair->name, dval->name);
		}
		else {
			fprintf(fd, "%s = %ld", pair->name, (long)pair->lvalue);
		}
		break;

	case PW_TYPE_IPADDR:
		ipaddr2str(buffer, pair->lvalue);
		fprintf(fd, "%s = %s", pair->name, buffer);
		break;

	case PW_TYPE_DATE:
		strftime(buffer, sizeof(buffer), "%b %e %Y",
					localtime((time_t *)&pair->lvalue));
		fprintf(fd, "%s = \"%s\"", pair->name, buffer);
		break;

#if defined( BINARY_FILTERS )
	case PW_TYPE_FILTER_BINARY:
		{
		int ix;

		fprintf( fd, "%s = ", pair->name );
		for ( ix = 0; ix < pair->lvalue; ix += 1 ) {
			fprintf( fd, " %02x", (unsigned char)(pair->strvalue[ ix ]) );
			}
		printf( "\n" );
 		}
		break;
#endif	/* BINARY_FILTERS */

	default:
		fprintf(fd, "Unknown type %d", pair->type);
		break;
	}
}

/*
 *	Write a whole list of A/V pairs.
 */
void fprint_attr_list_csv(FILE *fd, VALUE_PAIR *pair, int printPassword)
{
	while(pair) {
	  if (pair->attribute != PW_PASSWORD) {
	    fprint_attr_val_csv(fd, pair);
	    pair = pair->next;
	    if (pair)		
	      fprintf(fd, ",");
	  } else {
	    pair = pair->next;
	  }
	}
}


/*
 *	Write a printable version of the attribute-value
 *	pair to the supplied File.
 */
void fprint_attr_val_csv(FILE *fd, VALUE_PAIR *pair)
{
	DICT_VALUE	*dict_valget();
	char		buffer[32];
	u_char		*ptr;
	UINT4		vendor;
	int		left;
#ifdef MULTIVALUED_VSA
	int		i;
#endif

	fprintf(fd, "%d,", pair->attribute);

	switch(pair->type) {

	case PW_TYPE_STRING:
		ptr = (u_char *)pair->strvalue;
		if (pair->attribute != PW_VENDOR_SPECIFIC) {
			left = pair->length;
			while(left-- > 0) {
				/*
				 *	Ugh! Ascend gear sends "foo"
				 *	as "foo\0", length 4.
				 *	Suppress trailing zeros.
				 */
				if (left == 0 && *ptr == 0)
					break;
				if(!(isprint(*ptr)))
					fprintf(fd, "\\%03o", *ptr);
				else
					fputc(*ptr, fd);
				ptr++;
			}
			break;
		}
		/*
		 *	Special format, print out as much
		 *	info as we can.
		 */
		if (pair->length < 6) {
			fprintf(fd, "(invalid length: %d)\"", pair->length);
			break;
		}
		memcpy(&vendor, ptr, 4);
		ptr += 4;
		fprintf(fd, "V%d", (int)ntohl(vendor));
		left = pair->length - 4;
#if defined (MULTIVALUED_VSA)
		while (left >= 2) {
			fprintf(fd, ":T%d:L%d:", ptr[0], ptr[1]);
			left -= 2;
			ptr += 2;
			i = ptr[1] - 2;
			while (i > 0 && left > 0) {
				if(!(isprint(*ptr)))
					fprintf(fd, "\\%03o", *ptr);
				else
					fputc(*ptr, fd);
				ptr++;
				i--;
				left--;
			}
		}
#else
		fprintf(fd, ":T%d:L%d:", ptr[0], ptr[1]);
		left -= 2;
		ptr += 2;
		while(left > 0) {
		  fprintf(fd, "%02x", *ptr);
		  ptr++;
		  left--;
		}
#endif /*MULTIVALUED_VSA*/		
		break;

	case PW_TYPE_DATE:
	case PW_TYPE_INTEGER:
	        fprintf(fd, "%ld",(long)pair->lvalue);
	        break;

	case PW_TYPE_IPADDR:
		ipaddr2str(buffer, pair->lvalue);
		fprintf(fd, "%s", buffer);
		break;

#if defined( BINARY_FILTERS )
	case PW_TYPE_FILTER_BINARY:
		{
		int ix;

		for ( ix = 0; ix < pair->lvalue; ix += 1 ) {
			fprintf( fd, "%02x", (unsigned char)(pair->strvalue[ ix ]) );
			}
 		}
		break;
#endif	/* BINARY_FILTERS */

	default:
		fprintf(fd, "Unknown type %d", pair->type);
		break;
	}
}
