/*
 * acct.c	Accounting routines.
 *
 */
char acct_sccsid[] =
"@(#)acct.c	2.11  Copyright 1994 Livingston Enterprises Inc\n"
"		     Copyright 1998 Cistron Internet Services B.V.";


#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<sys/stat.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>
#include	<unistd.h>
#include	<signal.h>
#include	<errno.h>
#include	<sys/wait.h>

#include	"conf.h"

#include	"radiusd.h"
#if 0
#include	"radutmp.h"
#endif

extern char* accounting_method;

/*
 *	FIXME: this should be configurable.
 */
int	doradwtmp = 1;


static char trans[64] =
   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
#define ENC(c) trans[c]

/*
 *	UUencode 4 bits base64. We use this to turn a 4 byte field
 *	(an IP adres) into 6 bytes of ASCII. This is used for the
 *	wtmp file if we didn't find a short name in the naslist file.
 */
char *uue(void *in) {
	int i;
	static unsigned char res[7];
	unsigned char *data = (char *)in;

	res[0] = ENC( data[0] >> 2 );
	res[1] = ENC( ((data[0] << 4) & 060) + ((data[1] >> 4) & 017) );
	res[2] = ENC( ((data[1] << 2) & 074) + ((data[2] >> 6) & 03) );
	res[3] = ENC( data[2] & 077 );

	res[4] = ENC( data[3] >> 2 );
	res[5] = ENC( (data[3] << 4) & 060 );
	res[6] = 0;

	for(i = 0; i < 6; i++) {
		if (res[i] == ' ') res[i] = '`';
		if (res[i] < 32 || res[i] > 127)
			printf("uue: protocol error ?!\n");
	}
	return res;
}


int rad_accounting_sql(AUTH_REQ *authreq, int authtype, char *f, SQLSOCK *socket) {
	time_t		nowtime;
	struct tm	*tim;
        char		datebuf[20];
	char		*valbuf;
#if 0 /* FIXME: Database backup code */
	int		*sqlpid;
	int		sqlstatus;
	FILE		*backupfile;
	struct stat	backup;
	SQLREC backuprecord = {"", "", "",  "", 0, "", "", 0, "", 0, "", "", 0, 0, "", "", "", "", "", "", 0};
#endif
	SQLREC sqlrecord = {"", "", "", "", 0, "", "", 0, "", 0, "", "", 0, 0, "", "", "", "", "", "", 0};
	VALUE_PAIR	*pair;
	int		ret = 0;

	pair = authreq->request;
	strncpy(sqlrecord.Realm, authreq->realm, SQLBIGREC);
	while(pair != (VALUE_PAIR *)NULL) {

           /* Check the pairs to see if they are anything we are interested in. */
            switch(pair->attribute) {
                case PW_ACCT_SESSION_ID:
                	strncpy(sqlrecord.AcctSessionId, pair->strvalue, SQLBIGREC);
                	break;
                	
                case PW_USER_NAME:
                	strncpy(sqlrecord.UserName, pair->strvalue, SQLBIGREC);
                	break;
                	
                case PW_NAS_IP_ADDRESS:
			ipaddr2str(sqlrecord.NASIPAddress, pair->lvalue);
                	break;

                case PW_NAS_PORT_ID:
                	sqlrecord.NASPortId = pair->lvalue;
                	break;

                case PW_NAS_PORT_TYPE:
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
               			strncpy(sqlrecord.NASPortType, valbuf, SQLBIGREC);
			}
			break;

                case PW_ACCT_STATUS_TYPE:
       			sqlrecord.AcctStatusTypeId = pair->lvalue;
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
                		strncpy(sqlrecord.AcctStatusType, valbuf, SQLBIGREC);
			}
			break;

                case PW_ACCT_SESSION_TIME:
                	sqlrecord.AcctSessionTime = pair->lvalue;
                	break;

                case PW_ACCT_AUTHENTIC:
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
                		strncpy(sqlrecord.AcctAuthentic, valbuf, SQLBIGREC);
			}
			break;

                case PW_CONNECT_INFO:
                	strncpy(sqlrecord.ConnectInfo, pair->strvalue, SQLBIGREC);
                	break;

                case PW_ACCT_INPUT_OCTETS:
                	sqlrecord.AcctInputOctets = pair->lvalue;
                	break;

                case PW_ACCT_OUTPUT_OCTETS:
                	sqlrecord.AcctOutputOctets = pair->lvalue;
                	break;

                case PW_CALLED_STATION_ID:
                	strncpy(sqlrecord.CalledStationId, pair->strvalue, SQLLILREC);
                	break;

                case PW_CALLING_STATION_ID:
                	strncpy(sqlrecord.CallingStationId, pair->strvalue, SQLLILREC);
                	break;

                case PW_ACCT_TERMINATE_CAUSE:
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
                		strncpy(sqlrecord.AcctTerminateCause, valbuf, SQLBIGREC);
			}
			break;

                case PW_SERVICE_TYPE:
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
                		strncpy(sqlrecord.ServiceType, valbuf, SQLBIGREC);
			}
			break;

                case PW_FRAMED_PROTOCOL:
			valbuf = (char *)dict_valgetname(pair->lvalue, pair->name);
			if(valbuf != (char *)NULL) {
                		strncpy(sqlrecord.FramedProtocol, valbuf, SQLBIGREC);
			}
			break;

                case PW_FRAMED_IP_ADDRESS:
			ipaddr2str(sqlrecord.FramedIPAddress, pair->lvalue);
                	break;

                case PW_ACCT_DELAY_TIME:
                	sqlrecord.AcctDelayTime = pair->lvalue;
                	break;

                default:
                	break;
		}

		pair = pair->next;
	}


        nowtime = time(0) - sqlrecord.AcctDelayTime;
        tim = localtime(&nowtime);
        strftime(datebuf, sizeof(datebuf), "%Y%m%d%H%M%S", tim);

        strncpy(sqlrecord.AcctTimeStamp, datebuf, 20);
       

#if 0 /* FIXME: Make this actually work */

	/* If backup file exists we know the database was down */
	if(stat(MYSQLBACKUP, &backup) == 0) {
		if(backup.st_size > 0) {

			/* We'll fork a child to load records in the backup file */
			(pid_t)sqlpid = fork();
			if(sqlpid > 0) {

				/* suspend the parent while child reads records */
				while(waitpid((pid_t)sqlpid, &sqlstatus, 0) != (pid_t)sqlpid);
			}
			/* Child Process */
			if(sqlpid == 0) {
				if((backupfile = fopen(MYSQLBACKUP, "rwb")) == (FILE *)NULL) {
					log(L_ERR, "Acct: (Child) Couldn't open file %s", MYSQLBACKUP);
					exit(1);
				}

				/* Lock the mysql backup file, prefer lockf() over flock(). */
#if defined(F_LOCK) && !defined( BSD)
				(void)lockf((int)backupfile, (int)F_LOCK, (off_t)SQL_LOCK_LEN);
#else
				(void)flock(backupfile, LOCK_EX);
#endif  

				log(L_INFO, "Acct:  Clearing out sql backup file - %s", MYSQLBACKUP);

				while(!feof(backupfile)) {
					if(fread(&backuprecord, sizeof(SQLREC), 1, backupfile) == 1) {

						/* pass our filled structure to the
					 	   function that will write to the database */
						ret = sql_save_acct(socket, &backuprecord);

					}

				}
				unlink((const char *)MYSQLBACKUP);
				exit(0);
			}
		}
	}
#endif

	ret = sql_save_acct(socket, &sqlrecord);

	return ret;
}

int rad_accounting_file(AUTH_REQ *authreq, int authtype, char *f) 
{
        FILE            *outfd;
        char            nasname[128];
        char            buffer[512];
        char            *s;
        VALUE_PAIR      *pair;
        UINT4           nas;
        NAS             *cl;
	struct stat     st;

        /*
         *      See if we have an accounting directory. If not,
         *      return.
         */
        if (stat(radacct_dir, &st) < 0)
                return 0;

        /*
         *      Find out the name of this terminal server. We try
         *      to find the PW_NAS_IP_ADDRESS in the naslist file.
         *      If that fails, we look for the originating address.
         *      Only if that fails we resort to a name lookup.
         */
        cl = NULL;
        nas = authreq->ipaddr;
        if ((pair = pairfind(authreq->request, PW_NAS_IP_ADDRESS)) != NULL)
                nas = pair->lvalue;
        if (authreq->server_ipaddr)
                nas = authreq->server_ipaddr;

       if ((cl = nas_find(nas)) != NULL) {
                /* shortname and longname are < 128 bytes */
                if (cl->shortname[0])
                        strcpy(nasname, cl->shortname);
                else
                        strcpy(nasname, cl->longname);
        }

        if (cl == NULL) {
                s = ip_hostname(nas);
                if (strlen(s) >= sizeof(nasname) || strchr(s, '/'))
                        return -1;
                strcpy(nasname, s);
        }
 
	/*
         *      Create a directory for this nas.
         */
        sprintf(buffer, "%.100s%.150s/%.250s", dir_prefix, radacct_dir, nasname);
        (void) mkdir(buffer, 0755);

        /*
         *      Write Detail file.
         */
        sprintf(buffer, "%.100s%.100s/%.200s/%.100s", dir_prefix, radacct_dir, nasname, f ? f : "detail");
        if((outfd = fopen(buffer, "a")) == (FILE *)NULL) {
	   log(L_ERR, "Acct: Couldn't open file %s", buffer);
	   return -1;
        } else {
	   /* print timestamp */
	   fprintf(outfd, "%ld,", time(NULL));

	   /* Write each attribute/value to the log file */
	   pair = authreq->request;
	   fprint_attr_list_csv(outfd, pair, 0);
	   fputs("\n", outfd);
	   fclose(outfd);
	}

	return 0;
}
  

/*
 *	rad_accounting: call both the old and new style accounting functions.
 */
int rad_accounting(AUTH_REQ *authreq, int activefd, SQLSOCK *socket)
{
	int reply = 0;
	int auth;
	char pw_digest[16];

	/*
	 *	See if we know this client, then check the
	 *	request authenticator.
	 */
	auth = calc_acctdigest(pw_digest, authreq);

	if (auth < 0) {
		authfree(authreq);
		return -1;
	}

	if (strchr(accounting_method, 'f') != NULL) {
	   if (rad_accounting_file(authreq, auth, NULL) == 0)
	      reply = 1;
	}

	if (strchr(accounting_method, 's') != NULL) {	   
	   if (rad_accounting_sql(authreq, auth, NULL, socket))
	      reply = 1;
	}

	if (reply) {
		/*
		 *	Now send back an ACK to the NAS.
		 */
		rad_send_reply(PW_ACCOUNTING_RESPONSE,
			authreq, NULL, NULL, activefd);
	}

	authfree(authreq);

	return reply ? 0 : -1;
}

