#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "global.h"
#include "md5.h"


int getline(int descriptor, char *buffer, int maxlen);
int getvaluestr(char *source, char *destination, int destlen, char *attribute);

int main(int argc, char *argv[])
{
  unsigned char digest[16];
  char    request_authenticator[16];
  MD5_CTX context;
  char    *shared_secret = NULL;
  char    *password_hash = NULL;
  char    *cleartext_password = NULL;
  char    *valbuf = NULL;
  int     shared_secret_len = 0;
  int     password_hash_len = 0;
  int     done = 0;
  int     got_upw;
  int     got_ss;
  int     got_radauth;
  int     lap;
  int     lap2;

  shared_secret      = (char *)malloc(256);
  password_hash      = (char *)malloc(128);
  cleartext_password = (char *)malloc(129);
  valbuf             = (char *)malloc(4096);

  if ((shared_secret == NULL) ||
      (password_hash == NULL) ||
      (cleartext_password == NULL) ||
      (valbuf == NULL))
  {
    fprintf(stderr, "main(): not enough memory for buffer allocation!\n");
    return(1);
  }

  while (!done)
  {
    bzero(request_authenticator, 16);
    bzero(shared_secret, 256);
    bzero(password_hash, 128);
    bzero(cleartext_password, 129);
    bzero(valbuf, 4096);
    got_upw = 0;
    got_ss = 0;
    got_radauth = 0;

    do {
      getline(STDIN_FILENO, valbuf, 4095);
      if (!strncmp(valbuf, "User-Password=", strlen("User-Password="))) {
        password_hash_len = getvaluestr(valbuf, password_hash, 128, "User-Password");        
        got_upw = 1;
      } else if (!strncmp(valbuf, "RAD-Authenticator=", strlen("RAD-Authenticator="))) {
        getvaluestr(valbuf, request_authenticator, 16, "RAD-Authenticator");        
        got_radauth = 1;
      } else if (!strncmp(valbuf, "Secret=", strlen("Secret="))) {
        shared_secret_len = getvaluestr(valbuf, shared_secret, 256, "Secret");        
        got_ss = 1;
      }
    } while (strlen(valbuf) > 0);

    if (got_upw && got_ss && got_radauth)
    {
      bzero(valbuf, 4096);
      memcpy(valbuf, shared_secret, shared_secret_len);
      memcpy(valbuf+shared_secret_len, request_authenticator, 16);
      MD5Init(&context);
      MD5Update(&context, valbuf, 16+shared_secret_len);
      MD5Final(digest, &context);
      lap2 = 0;
      while (lap2 < password_hash_len)
      {
        for (lap = 0; lap < 16; lap++)
        {
          cleartext_password[lap+lap2] = password_hash[lap+lap2] ^ digest[lap];
        }

        bzero(valbuf, 4096);
        memcpy(valbuf, shared_secret, shared_secret_len);
        memcpy(valbuf+shared_secret_len, password_hash+lap2, 16);
        MD5Init(&context);
        MD5Update(&context, valbuf, 16+shared_secret_len);
        MD5Final(digest, &context);
        
        lap2 += 16;
      }
      write(STDOUT_FILENO, "User-Password=\"", strlen("User-Password=\""));
      write(STDOUT_FILENO, cleartext_password, strlen(cleartext_password));
      write(STDOUT_FILENO, "\"\n\n", strlen("\"\n\n"));
    } else {
      syslog(LOG_INFO, "mod_upw: did not receive all attributes, operation aborted.");
      write(STDOUT_FILENO, "\n\n", strlen("\n\n"));
    }
  }
  
  free(valbuf);
  free(cleartext_password);
  free(password_hash);
  free(shared_secret);
  free(request_authenticator);

  return(0);
}

int getline(int descriptor, char *buffer, int maxlen)
{
  int  pos = 0;
  char c = 'x';
  
  bzero(buffer, maxlen);
  do {
    if (read(descriptor, &c, 1) == 1)
    {
      if (c != '\n')
      {
        *(buffer+pos) = c;
        pos++;
      }
    }
  } while ((pos < maxlen) && (c != '\n'));

  return(0);
}

int getvaluestr(char *source, char *destination, int destlen, char *attribute)
{
  char valbuf[6];
  char *sptr;
  char *dptr;
  int  lap;
  int  retval = 0;

  sptr = source + strlen(attribute) + 2;
  lap  = strlen(source) - (strlen(attribute)+3);
  dptr = destination;
  bzero(dptr, destlen);

  while (lap > 0)
  {
    if (!strncmp(sptr, "\\x", 2))
    {
      bzero(valbuf, 6);
      sprintf(valbuf, "0x%c%c", *(sptr+2), *(sptr+3));
      *dptr = (char)strtol(valbuf, (char **)NULL, 16);
      sptr+=4;
      lap-=4;
    } else {
      *dptr = *sptr;
      sptr++;
      lap--;
    }
    retval++;
    dptr++;
  }

  return(retval);
}

