### Compiled-in paths and installation defaults. 
#
# Installation can be done under a different root by setting INST_PREFIX
# at make install time.
#
DIR_INC		= /usr/local/include/evblib
DIR_LIB		= /usr/local/lib


### Platform compatibility flags
#
# Use S_CF_*, S_LF_* and S_LL_* when you need to pass things to a small number
# of targets' CF_TGT (CFLAGS), LF_TGT (LDFLAGS) or LL_TGT (LDLIBS), resp. 
#
# Definitions that are used by many targets should be put in SYSDEFS so that
# they end up in sysdefs.h.
#
# SYSDEFS is split up according to functionality area to avoid creating an
# all-or-nothing situation, allowing subsets of this library to be built even
# when certain things are unknown or when all options are unspported.

SYSDEFS		= -DHAVE_STDINT
#SYSDEFS	= "-Duint32_t=unsigned long"
SYSDEFS_MM	= -DHAVE_GETPAGESIZE -DHAVE_SYSVSHM
#SYSDEFS_MM	= "-DGETPAGESIZE=((size_t)8192)" -DHAVE_POSIXSHM
SYSDEFS_LIBC	= 
SYSDEFS_KERN	= "-DRANDOM_DEV=\"/dev/urandom\""


### Build flags for all targets
#
#CF_ALL		= -O2 -Wall
#LF_ALL		= -s
#LL_ALL		=
CF_ALL		= -g -Wall
LF_ALL		=
LL_ALL		=


### Build tools
# 
# The C compiler named here must output full (header) dependencies in $(@).d.
# It may be necessary to create a script similar to ccd-gcc for your compiler.
# The reason for the abstraction is that there are even differences in 
# behaviour here among GCC versions.
#
CMPLR		= ./build/ccd-gcc
DEFHDR		= ./build/hdr
INST		= ./build/install
ARCHIVE		= ar rc $@ $^
#
PREP		= $(CMPLR) $(CF_ALL) $(CF_TGT) -E -o $@ $<
COMP		= $(CMPLR) $(CF_ALL) $(CF_TGT) -o $@ -c $<
LINK		= $(CMPLR) $(LF_ALL) $(LF_TGT) -o $@ $^ $(LL_TGT) $(LL_ALL)
COMPLINK	= $(CMPLR) $(CF_ALL) $(CF_TGT) $(LF_ALL) $(LF_TGT) -o $@ $< $(LL_TGT) $(LL_ALL)


### Standard parts
#
include	Rules.mk

