# This is an implementation of non-recursive make using GNU Make. See
# http://www.tip.net.au/~millerp/rmch/recu-make-cons-harm.html and
# http://www.xs4all.nl/~evbergen/nonrecursive-make.html
#
# Note: this design uses GNU Make's target-specific variables, because it's the
# only way to get variables that are different for each subdirectory (most
# notably, $(d)), into the build recipes. Once you go that way, you can as well
# use the feature to specify (extra) objects and libraries to be linked or
# archived.


# Standard stuff

VERSION		:= pre1.2-$$(date +%y%m%d)

.SUFFIXES:
.SUFFIXES:	.c .o

all:		targets


# Subdirectories, in random order

SUBDIRS		:= auto sysdefs misc str buffer fastring stream strio hash db tests

$(foreach dir,$(SUBDIRS),$(eval include $(dir)/Rules.mk))


# General directory independent rules

CF_ALL		:= $(CF_ALL) -I.

%.o:		%.c $(TGT_INC_sysdefs)
		$(COMP)

%.i:		%.c
		$(PREP)

%:		%.o
		$(LINK)

%:		%.c $(TGT_INC_sysdefs)
		$(COMPLINK)


# Local rules

TGT_LIB		:= $(TGT_LIB) libevb1.a
CLEAN		:= $(CLEAN) libevb1.a

libevb1.a:	$(TGT_OBJ)
		$(ARCHIVE)


# These two targets collect real targets, i.e. ones that can be built.

.PHONY:		targets
targets:	$(TGT_LIB)

.PHONY:		tests
tests:		$(TGT_TEST)


# These targets merely contain commands to be executed, i.e. they collect only
# .PHONY targets, even if they're not explicitly marked as such.  The install
# target does not collect dependencies (other than for forcing things to be
# built) because it's always considered 'out of date' anway as it's a .PHONY
# target. Instead, it collects installation commands in CMD_INST, which will be
# ran in addition to the standard INST invocations to install the known
# targets.

.PHONY:		clean
clean:
		rm -f $(CLEAN)

.PHONY:		install
install:	targets 
		$(INST) $(foreach dir,$(SUBDIRS),$(TGT_INC_$(dir)) -m 644 -d $(INST_PREFIX)$(DIR_INC)/$(dir))
		$(INST) $(TGT_LIB) -m 644 -d $(INST_PREFIX)$(DIR_LIB)
		@echo
		@echo If no error messages appeared, evblib-$(VERSION) is now installed successfully. 
		@echo

.PHONY:		dist
dist:		clean
		@d=`basename $$(pwd)` ; \
		 n=evblib-$(VERSION) ; \
		 mv ../$$d ../$$n ; \
		 tar -C .. -czf ../$$n.tar.gz $$n --exclude .svn ; \
		 mv ../$$n ../$$d ; \
		 echo Created $$n.tar.gz


# Prevent make from removing any build targets, including intermediate ones

.SECONDARY:	$(CLEAN)

