#ifndef _LIST_H
#define _LIST_H 1


/* List management macros. The head and tail arguments must be pointers to
   the actual head and tail variables, which must be a pointer of the same 
   type as obj. Objects are required to have 'next' and 'prev' pointers of
   the same type. */

#define LIST_ADDTAIL(head, tail, obj)					\
    do {								\
	(obj)->prev = *(tail);						\
	(obj)->next = 0;						\
	if (*(tail)) (*(tail))->next = (obj);				\
	else *(head) = (obj);						\
	*(tail) = (obj);						\
    } while(0)

#define LIST_ADDHEAD(head, tail, obj)					\
    do {								\
	(obj)->next = *(head);						\
	(obj)->prev = 0;						\
	if (*(head)) (*(head))->prev = (obj);				\
	else *(tail) = (obj);						\
	*(head) = (obj);						\
    } while(0)

#define LIST_DEL(head, tail, obj)					\
    do {								\
	if ((obj)->next) (obj)->next->prev = (obj)->prev;		\
	if ((obj)->prev) (obj)->prev->next = (obj)->next;		\
	if ((obj) == *(head)) *(head) = (obj)->next;			\
	if ((obj) == *(tail)) *(tail) = (obj)->prev;			\
    } while(0)


#endif


/*
 * vim:softtabstop=4:sw=4
 */

