/*
 * PAGEMIRROR - creates an area of memory that's mapped twice, at consecutive
 * 		addresses
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 */


/*
 * INCLUDES & DEFINES
 */


#include <sys/types.h>			/* for size_t */

#include <evblib/sysdefs/sysdefs-mm.h>		/* HAVE_ flags, GETPAGESIZE */


/*
 * TYPES
 */


struct mirrpage {
    char *p;			/* pointer to first part of mirror */
    size_t l;			/* length of one part of mirror */
};


/*
 * FUNCTIONS
 */


struct mirrpage *mirr_new(size_t size, struct mirrpage *ret);

#if defined (HAVE_POSIXSHM) || defined (HAVE_DEVZEROSHM) || defined (HAVE_SYSVSHM)

void mirr_del(struct mirrpage *mp);
#define mirr_update(mp,ofs,size)    /* */

#else

#warning No SHM - using pseudo-mirrorpage - call mirr_update after each write!

#include <malloc.h>

#define mirr_del(mp) \
    free((mp)->p)

#define mirr_update(mp,ofs,size)					      \
    if ((ofs) + (size) < (mp)->l) {					      \
	if (size) memcpy((mp)->p + (mp)->l + (ofs), (mp)->p + (ofs), (size)); \
    } else {								      \
	memcpy((mp)->p + (mp)->l + (ofs), (mp)->p + (ofs), (mp)->l - (ofs));  \
	memcpy((mp)->p, (mp)->p + (mp)->l, (size) - ((mp)->l - (ofs)));	      \
    }

#endif

