#ifndef _MISC_H
#define _MISC_H 1


/* Macros and prototypes for miscellaneous support functions */


#include <sys/types.h>			/* for size_t */

#include <evblib/sysdefs/byteorder.h>


/* Min/Max macros */


#define MIN(a, b)	((a) < (b) ? (a) : (b))
#define MAX(a, b)	((a) > (b) ? (a) : (b))



/* Allocate memory and exit immediately if that fails */

void *safe_malloc(size_t len);



/* A read that never returns -1. EINTR is handled, the rest ends the program. 
   Not suitable for nonblocking I/O, unless you can guarantee that no EGAIN
   will occur. */

int safe_read(int fd, void *p, size_t l);



/* Get random data from RANDOM_DEV */

void get_random_data(char *p, ssize_t len);



/* Transform an octet string into its hexadecimal representation */

void hex(char *buf, void *src, ssize_t len);

/* Convert values into their hexadecimal representation. Not macros,
 * because that would either require modifyable lvalue arguments or
 * local variables, which aren't widely supported enough. */

static inline void hex8(char *buf, char val)
{
    hex(buf, &val, 1);
}

static inline void hex16(char *buf, uint16_t val)
{
    val = net16(val);
    hex(buf, &val, 2);
}

static inline void hex32(char *buf, uint32_t val)
{
    val = net32(val);
    hex(buf, &val, 4);
}

/* Print a hexdump of a buffer to a file descriptor */

void hexdumpfd(int fd, void *buf, ssize_t len, ssize_t dispofs);


#endif


/*
 * vim:softtabstop=4:sw=4
 */

