/* This is the body for functions that convert char *p, ssize_t l
   STR strings to integer values. You need to put the function header
   and declaration of a variable 'ret' of correct type before this
   file. */

/* Implementation note: because we read our input byte by byte, we can
   use an equality test instead of an equal-or-greater test to see if we have
   reached the end of the buffer. That allows us to automatically implement a
   -1 length as an unlimited length; 'i' will never reach p - 1 as 'i' starts
   from p and is only incremented (unless of course we wrap around and
   process 4Gb of input, but then doing it only once is exactly what we want) */

/* Convenience macros */

#undef RET
#undef ADV
#define RET		goto endstrto;
#define ADV		if (++i == e) RET

    char *i, *e;
    int neg, c;

    /* Initialize */

    ret = 0; neg = 0; i = p; e = p + l; 
    if (!l) RET;

    /* Test if we're dealing with negative input (always allowed, returns
       2's complement in case of unsigned output) */

    if (*i == '-') { neg++; ADV; }

    /* Autodetect base */

    if (base <= 0) {
    	base = 10;
	if (*i == '0') {
	    base = 8; ADV;
	    if (*i == 'x') { base = 16; ADV; }
	}
    }

    /* Convert */

    for(;;) {
	c = *i & 0xff;
	c -= '0';
	if (c < 0) break;
	if (c > 9) {
	    if (base <= 10) break;
	    c += '0'; 
	    if (c >= 'a' && c < 'a' + base) c -= 'a' - 10;
	    else if (c >= 'A' && c < 'A' + base) c -= 'A' - 10;
	    else break;
	}
	ret = ret * base + c;
	ADV;
    }
    if (neg) ret = -ret;

endstrto:
    if (got) *got = i - p;
    return ret;


/*
 * vim:softtabstop=4:sw=4:syntax=c
 */
