# Standard things

parent_$(dir)	:= $(d)
d		:= $(dir)


# Local rules and targets
#
TGTS_$(d)	:= $(d)/sysdefs.h $(d)/sysdefs-mm.h $(d)/sysdefs-cc.h \
		   $(d)/sysdefs-libc.h $(d)/sysdefs-kern.h
TGT_INC_$(d)	:= $(TGTS_$(d)) $(d)/byteorder.h $(d)/systypes.h
CLEAN		:= $(CLEAN) $(TGTS_$(d))


# General stuff, such as HAVE_STDINT

$(d)/sysdefs.h:	$(d)/Rules.mk Makefile
		$(DEFHDR) $@ $(SYSDEFS)

# Memory management, such as HAVE_GETPAGESIZE, HAVE_SYSVSHM

$(d)/sysdefs-mm.h:	$(d)/Rules.mk Makefile
		$(DEFHDR) $@ $(SYSDEFS_MM)

# Compiler specific things, such as HAVE_LOCAL_DECL, HAVE_VA_PASSED_BY_VALUE */

$(d)/sysdefs-cc.h:	$(d)/Rules.mk Makefile
		$(DEFHDR) $@ $(SYSDEFS_CC)

# C library specific things, such as HAVE_VSNPRINTF */

$(d)/sysdefs-libc.h:	$(d)/Rules.mk Makefile
		$(DEFHDR) $@ $(SYSDEFS_LIBC)

# OS specific things, such as RANDOM_DEV

$(d)/sysdefs-kern.h:	$(d)/Rules.mk Makefile
		$(DEFHDR) $@ $(SYSDEFS_KERN)

# Note: we install these files, so that other packages needn't bother 
# themselves with determining HAVE_ macros. Ultimately we can even put
# some autodetection stuff here.

# Standard things

d               := $(parent_$(d))
