#include <stdio.h>

#include <evblib/stream/stream.h>
#include <evblib/hash/sfh.h>
#include <evblib/db/hashtable.h>


struct myent {
	int linenr, wordnr, count;
};


hashval_t myhashfn(void *p, ssize_t l)
{
	return l ^ *(uint32_t *)p;
}


int main()
{
	STRM_T *si;
	HTBL_T ht;
	HTHENT_T *he;
	HTENT_T *ent;
	STR_T line, word, s;
	hashval_t hv;
	struct myent *m;
	int wn, kn;

	printf("Enter a set of lines, terminated with EOF\n");

	si = strm_new(0, 1024);
	if (!si) { fputs("Could not create stream!\n", stderr); return 1; }

	if (htbl_init(&ht, 1024, sfh) < 0) { perror("Could not create hash table!\n"); return 1; }

	/* Store words as key, with line number and occurence count as data */

	while(line = strm_getline(si), line.l) {
	    wn = 0;
	    while(word = str_getword(&line, "\n\r\t ", 4), word.l) {
		ent = htbl_getent(&ht, word.p, word.l, &he, &hv);
		if (!ent) {
			m = (struct myent *)malloc(sizeof(struct myent));
			if (!m) { perror("malloc"); return 1; }
			m->linenr = si->aux;
			m->wordnr = ++wn;
			m->count = 1;
			s = str_safedup(word.p, word.l);
			hthe_addent(he, hv, s.p, s.l, (char *)m,
				    sizeof(struct myent), 
				    HTBL_PF_TOFRONT | HTBL_PF_FREEALL);
			continue;
		}
		m = (struct myent *)ent->data.p;
		m->linenr = si->aux;
		m->wordnr = wn;
		m->count++;
	    }
	}

	/* Retrieve all keys from the table */

	kn = 0;
	for(he = htbl_getfirsthe(&ht); he; he = htbl_getnexthe(&ht, he)) {
		wn = 0;
		for(ent = htbe_getfirstent(he); ent; ent = htbe_getnextent(he, ent)) {
			m = (struct myent *)ent->data.p;
			printf("%6d:%d:\t %6d %.*s\n",
			       m->linenr, m->wordnr, m->count,
			       ent->key.l, ent->key.p);
			wn++;
		}
		kn++;
		printf("=== Slot %6d: %d entries\n", kn, wn);
	}

	strm_del(si);
	htbl_done(&ht);
	return 0;
}
