### Installation paths and compiled-in defaults
#
DIR_BIN		= /usr/local/bin
DIR_SBIN	= /usr/local/sbin
DIR_ETC		= /usr/local/etc/openradius
DIR_LIB		= /usr/local/lib/openradius
FILE_LOG	= /var/log/openradius/radiusd.log
FILE_LOG_EAPSRV	= /var/log/openradius/eapserver.log


### Modules that will be built and installed
#
TGT_LIB		+= modules/ascfile/ascfile
TGT_LIB		+= modules/unixpasswd/unixpasswd
TGT_LIB		+= modules/radlogger/radlogger
TGT_LIB		+= modules/delay/delay
TGT_LIB		+= modules/radsql/radsql
TGT_LIB		+= modules/memory/memory
TGT_LIB		+= modules/debug/debug
#TGT_LIB 	+= modules/radldap/radldap
#TGT_LIB		+= modules/eapserver/eapserver
#TGT_LIB		+= modules/eaptls/eaptls


### System compatibility flags, used in some targets' CF_TGT, LF_TGT or LL_TGT
#
S_CF_U_INT32_T	= -DU_INT32_T=u_int32_t
S_CF_SYSLOG	= -DHAVE_SYSLOG
S_CF_CRYPT	= -DHAVE_CRYPT
S_CF_VSNPRINTF 	= -DHAVE_VSNPRINTF
S_CF_SIGACTION 	= -DHAVE_SIGACTION
S_CF_EVB	= -I/usr/local/include
S_CF_TLS	=
S_LL_INET	=
S_LL_CRYPT	= -lcrypt
S_LL_EVB	= -levb1
S_LL_TLS	= -lgnutls


### Build flags for all targets
#
#CF_ALL		= -O2 -Wall
#LF_ALL		= -s
#LL_ALL		=
CF_ALL		= -g -Wall
LF_ALL		= 
LL_ALL		=


### Module-specific build flags
#
CF_RADLDAP	= -I/usr/local/include/openldap
LF_RADLDAP	= -L/usr/local/lib
LL_RADLDAP	= -lldap


### Build tools
# 
# The C compiler named here must output full (header) dependencies in $(@).d.
# It may be necessary to create a script similar to ccd-gcc for your compiler.
# 
CMPLR		= ./build/ccd-gcc
DEFHDR		= ./build/hdr
INST		= ./build/install
ARCHIVE		= ar rc $@ $^
#
COMP		= $(CMPLR) $(CF_ALL) $(CF_TGT) -o $@ -c $<
LINK		= $(CMPLR) $(LF_ALL) $(LF_TGT) -o $@ $^ $(LL_TGT) $(LL_ALL)
COMPLINK	= $(CMPLR) $(CF_ALL) $(CF_TGT) $(LF_ALL) $(LF_TGT) -o $@ $< $(LL_TGT) $(LL_ALL)


### Standard parts
#
include	Rules.mk

