/*
 * JOBS - Handles job creation from requests, job juggling on interfaces
 *	  and channels, and job ending after converting them to responses.
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/08/25 - EvB - Created
 * 2001/10/29 - EvB - Moved chan_put/getjob here as job_to/fromchan etc.
 */


/*
 * INCLUDES & DEFINES
 */


#include <srvtypes.h>		/* For JOB, SOCK, IFACE */


/*
 * PROTOTYPES
 */


/* Creates a new job from a request received from a ready socket or ring */

JOB *job_new_fromsock(SOCK *s, time_t t);
JOB *job_new_fromring(CONF *c, RING *r, ssize_t len, 
		      RING *reply, int replyfd, time_t t);

/* Deletes the job without responding */

void job_del(JOB *j);

/* Runs the expression until interface trap or done. If done, signs,
   responds, deletes the job and returns 0. If error, deletes the job and
   returns 0. If interface trap, returns the interface. */

IFACE *job_run(CONF *c, JOB *j);

/* Assign a job to an interface. Will select a channel in round-robin mode. 
 * If it fails (only reason currently: PID required that's not found) it
 * returns nonzero, and the job should be continued. */

int job_toiface(IFACE *i, JOB *j, time_t t);

/* Assign a job to a particular channel, forming a message to send through it, 
   enabling its transmitter and putting the job on its receive queue */

void job_tochan(CHAN *ch, JOB *j, time_t t);

/* Get a job from a channel's receive queue after receiving a full answer */

JOB *job_fromchan(CHAN *ch, time_t t);

