
#include <stdlib.h>
#include <unistd.h>

#include <metadict.h>
#include <metaops.h>	/* For META_AV etc. */

#include <debug.h>


int main()
{
	char *input, *output;
	ssize_t inplen, outlen;
	META *m;
	META_SPC *spc;
	META_AV *avlist;

	msg_init(-1, 0);

	inplen = 20 + 6 + 6 + 9 + 8 + 6 + 0x16 + 0xe + 6 + 0xb;
	input = "\x01\xaa\x00\x6c"
	        "ABCDEFGHIJKLMNOP"
		"\x06\x06\x00\x00\x00\x02"
		"\x07\x06\x00\x00\x00\x02"
	        "\x20\x09TestNas"
	        "\x01\x08Myself"
		"\x04\x06\xc0\xa8\x05\xfe"
		"\x1a\x16" "\x00\x00\x00\x09" "\x01\x08" "TEST 1"
				              "\x01\x08" "TEST 2"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 3"
	        "\x05\x06\x00\x00\x00\x05"
		"\x02\x0bs3cret\x01\x02\x03";

	outlen = 16384;
	output = (char *)malloc(outlen);
	if (!output) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not alloc message!\n");
		return 1;
	}

	m = meta_newfromdict("../../raddb");	/* Use as base path */
	if (!m) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not open dictionary!\n");
		return 1;
	}

	spc = meta_getspcbyname(m, "RAD-PKT");
	if (!spc) { 
		msg(F_MISC, L_ERR, "main: ERROR: Space 'RAD-PKT' not found!\n");
		return 1;
	}

	avlist = meta_decode(m, spc, 0, input, inplen, 0);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding data!\n");
		return 1;
	}

	outlen = meta_avtomsg(m, avlist, output, outlen, AVMSG_ASCII
		+ AVMSG_ADDTAB + AVMSG_ADDSPACES + AVMSG_ADDTYPE
		+ AVMSG_ADDIGNORE, 0);
	write(1, output, outlen);
	meta_freeavlist(avlist);
	meta_del(m);
	free(output);

	return 0;
}
