#include <stdio.h>	/* for fprintf() */
#include <errno.h>	/* for errno */
#include <string.h>	/* for strerror(), strtok() */
#include <stdlib.h>	/* for strtoul() */

#include <metadict.h>
#include <metaops.h>

#define DEBUGLEVEL 3
#include <debug.h>




int main()
{
	META *m;
	META_SPC *s;
	char *input;
	static char output[2048];
	META_ORD len;
	META_AV *avlist, *avdstlst, *av;
#if 0
	int n;
#endif

	msg_init(-1, 0);
	msg_setthresh(F_RECV, L_DEBUG);
	msg_setthresh(F_SEND, L_DEBUG);

	printf("\nREADING DICTIONARY\n");
	
	m = meta_newfromdict("../../raddb");	/* Use as base path */
	if (!m) {
		fprintf(stderr, "metatest: ERROR: could not create meta object "
				"from dictionary!\n");
		return 1;
	}

#if 0
	printf("\nSPACES\n");
	for(spc = m->spaces; spc; spc = spc->next) {
		s = spc;
		printf("Space %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
		s = meta_getspcbyname(m, spc->name);
		printf("    N %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
		s = meta_getspcbynr(m, spc->nr);
		printf("    O %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
	}

	printf("\nVENDORS\n\n");
	for(v = m->vendors; v; v = v->next) {
		printf("Vendor %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
		v = meta_getvndbyname(m, vnd->name);
		printf("     N %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
		v = meta_getvndbynr(m, vnd->nr);
		printf("     O %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
	}

	printf("\nDATA ITEMS\n");
	for(s = m->spaces; s; s = s->next) {

		for(i = s->items; i; i = i->next) {

			printf(" Item %p: spc=%p, vnd=%ld, nr=%ld, len_ofs=%d, len_size=%d, len_adj=%d, val_ofs=%d, val_size=%d, val_type=%d, subspace=%p, name=%s\n", i, i->spc, i->vnd, i->nr, i->len_ofs, i->len_size, i->len_adj, i->val_ofs, i->val_size, i->val_type, i->subspace, i->name);
		}
	}
#endif

	printf("\nDECODING TEST\n");
	input = "\x01\xaa\x00\x63"
		"ABCDEFGHIJKLMNOP"
		"\x06\x06\x00\x00\x00\x02"
		"\x07\x06\x00\x00\x00\x02"
		"\x20\x09TestNas"
		"\x01\x00"
		"\x01\x08Myself"
		"\x04\x06\xc0\xa8\x05\xfe"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 1"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 2"
		"\x05\x06\x00\x00\x00\x05"
		"\x02\x08s3cret";

	s = meta_getspcbyname(m, "RAD-PKT");
	if (!s) { 
		msg(F_MISC, L_ERR, "main: ERROR: Space 'RAD-PKT' not found!\n");
		return 1;
	}

	avlist = meta_decode(m, s, 0, input, 0x63, 0);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding data!\n");
		return 1;
	}
	/* Remove explicit length field */
	for(av = avlist; av; av = av->next) {
		if (av->i->spc->nr == 1 && av->i->nr == 2) av->flags |= AV_DEL;
	}
	meta_printavlist(m, avlist, 0);

	printf("\nBUILDTREE TEST\n");

	meta_buildtree(avlist, &avdstlst, s);
	meta_printavlist(m, avdstlst, 0);
	meta_freeavlist(avlist);

	printf("\nENCODING TEST\n");

	memset(output, 0, sizeof(output));
	len = meta_encode(s, output, sizeof(output), avdstlst, 0);
	if (len == -1) {
		msg(F_MISC, L_ERR, "main: ERROR: error encoding data!\n");
		return 1;
	}
	printf("Hexdump of %ld (0x%lx) bytes:\n", len, len);
	hexdump(output, len);
	meta_freeavlist(avdstlst); avdstlst = 0;

	printf("\nDECODING AGAIN\n");
	avlist = meta_decode(m, s, 0, output, len, 0);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding just encoded "
				   "data!\n");
		return 1;
	}
	meta_printavlist(m, avlist, 0);
	meta_freeavlist(avlist);

	meta_del(m);
	return 0;
}

