/*
 * MISC - Miscellaneous utility functions
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/25 - EvB - Moved hex and memrchr here from lang_vm.c
 */

char misc_id[] = "MISC - Copyright (C) 2001 Emile van Bergen.";


 /*
  * INCLUDES & DEFINES
  */


#include <misc.h>


/*
 * FUNCTIONS
 */


char *memrchr(char *s, int c, ssize_t len)
{
	char *ret;

	if (len && s) {
		for(ret = s + len - 1; ret >= s; ret--) 
			if (*ret == c) return ret;
	}
	return 0;
}


void hex(char *buf, const char *src, ssize_t len)
{
	static char *hextbl = "0123456789abcdef";

	for( ; len > 0; len--) {
		*buf++ = hextbl[(*src >> 4) & 0xf];
		*buf++ = hextbl[*src++ & 0xf];
	}
}

