/*
 * MISC - Miscellaneous utility functions
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/25 - EvB - Moved hex and memrchr here from lang_vm.c
 * 2001/10/29 - EvB - Moved netint32 here from channels.c so we can also
 * 		      use it in meta_ops.c
 */


#ifndef __MISC_H
#define __MISC_H	1


 /*
  * INCLUDES & DEFINES
  */


#include <sys/types.h>		/* for ssize_t */


#define MIN(a, b)	((a) < (b) ? (a) : (b))
#define MAX(a, b)	((a) > (b) ? (a) : (b))


/* Try to establish endianness - supports BSD, GNU and SysV style */

#ifdef BYTE_ORDER	/* BSD */
#ifdef BIG_ENDIAN
#if BYTE_ORDER == BIG_ENDIAN
#define ISBIGENDIAN	1
#endif
#endif
#else

#ifdef __BYTE_ORDER	/* GNU */
#ifdef __BIG_ENDIAN
#if __BYTE_ORDER == __BIG_ENDIAN
#define ISBIGENDIAN	1
#endif
#endif
#else

#ifdef _BIG_ENDIAN	/* SysV */
#define ISBIGENDIAN	1
#else
#ifndef _LITTLE_ENDIAN
#error Cannot determine endianness! Please add a test for your system to common/misc.h
#endif
#endif

#endif
#endif


/* Macro to convert from/to 32-bit values in network order */

#ifdef ISBIGENDIAN
#define netint32(n)	((uint32_t)(n))
#else
#define netint32(n)	((((uint32_t)(n) & (uint32_t)0x000000ffUL) << 24) |  \
			 (((uint32_t)(n) & (uint32_t)0x0000ff00UL) << 8)  |  \
			 (((uint32_t)(n) & (uint32_t)0x00ff0000UL) >> 8)  |  \
			 (((uint32_t)(n) & (uint32_t)0xff000000UL) >> 24))
#endif


/*
 * PROTOTYPES
 */

char *memrchr(char *s, int c, ssize_t len);
void hex(char *buf, const char *src, ssize_t len);


#endif

