/*
 * SRVTYPES - Server data structures
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/26 - EvB - Created
 */


#ifndef __SRVTYPES_H
#define __SRVTYPES_H 	1


/*
 * INCLUDES & DEFINES
 */


#include <sys/types.h>	/* For ssize_t, FD_SETSIZE and before socket.h */
#include <sys/socket.h>	/* Before netinet/in.h */
#include <netinet/in.h>	/* For sockaddr_in */

#include <subprocs.h>	/* For PROC */
#include <metadata.h>	/* For META_ORD, META_NAME */


/*
 * TYPES
 */


typedef struct sock {
	struct sock *next;
	struct conf *c;		/* inited */
	META_ORD ip, port;	/* inited */
	int fd;			/* not opened */
} SOCK;


typedef struct job {
	struct job *next, *prev;
	struct vm *vm;
	char *pkt, *msg;	/* msg is used while on shared send queue, to */
	ssize_t pktlen, msglen;	/* prevent re-encoding when finding a channel */
	int replyfd;
	struct sockaddr_in replyadr;
} JOB;


typedef struct chan {
	struct chan *next;
	struct iface *iface;	/* inited */
	JOB *recvqh, *recvqt;
	PROC *proc;		/* inited - needed to give the right proc a */
				/* kick if it's idle and a new req. appears */
} CHAN;


typedef struct iface {
	struct iface *next;
	struct conf *c;		/* inited */
	META_NAME name;		/* inited */
	JOB *sendqh, *sendqt;
	struct meta_av *sendacl, *recvacl;	/* inited */
	CHAN *chans, *rrch;	/* inited */
	int xfertimeout, flags;	/* inited - only really used to pass to procs */
} IFACE;


typedef struct conf {
	SOCK *sources;		/* inited */
	IFACE *ifaces;		/* inited */
	PROC *procs;		/* inited - list of procs of all interfaces */
	struct insn *expr;	/* inited */
	ssize_t exprlen;	/* inited */

	/* These are convenience pointers, to save a lot of getitembynr calls */
	META *m;
	META_SPC *ds_rad_pkt;
	META_ITEM *di_authenticator;
	META_SPC *ds_internal;
	META_ITEM *di_timestamp;
	META_ITEM *di_ip_source;
	META_ITEM *di_ip_dest;
	META_ITEM *di_udp_source;
	META_ITEM *di_udp_dest;
} CONF;


#endif

