/*
 * FASTRING - support for fast ring buffers using the mirror page technique
 *
 * Author:
 * Emile van Bergen, emile@e-advies.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 */


/* 
 * INCLUDES & DEFINES
 */


#include <pagemirr.h>

#define ring_capacity(R)  ((R)->mp.l)
#define ring_maxget(R)	  ((R)->maxget)
#define ring_maxput(R)	  ((R)->mp.l - (R)->maxget)
#define ring_empty(R)	  (((R)->maxget = 0), ((R)->r = (R)->w = (R)->mp.p))

#define ring_get(R,len) \
	do { \
	    (R)->r = (R)->mp.p + (((R)->r - (R)->mp.p + (len)) % (R)->mp.l); \
	    (R)->maxget -= (len); \
	} while(0)

#define ring_put(R,len) \
	do { \
	    mirr_update(&(R)->mp, (R)->w - (R)->mp.p, (len)); \
	    (R)->w = (R)->mp.p + (((R)->w - (R)->mp.p + (len)) % (R)->mp.l); \
	    (R)->maxget += (len); \
	} while(0)


/* 
 * TYPES
 */


typedef struct {
    struct mirrpage mp;
    char *r, *w;
    size_t maxget;
} RING;


/*
 * PROTOTYPES
 */


RING *ring_new(size_t size);
void ring_del(RING *r);

