/*
 * MISC - Miscellaneous utility functions
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/25 - EvB - Moved hex and memrchr here from lang_vm.c
 * 2001/10/29 - EvB - Moved netint32 here from channels.c so we can also
 * 		      use it in meta_ops.c
 * 2002/02/23 - EvB - Added encrypt_attr_pap 
 * 2004/01/13 - EvB - Added safe_read, STR
 * 2004/05/11 - EvB - Split off STR and functions
 */


#ifndef __MISC_H
#define __MISC_H	1


 /*
  * INCLUDES & DEFINES
  */


#include <sys/types.h>		/* for ssize_t */
#include <sys/param.h>		/* for endianness macros */

#include <platform.h>		/* for HAVE_GETPAGESIZE */


#ifndef MIN
#define MIN(a, b)	((a) < (b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a, b)	((a) > (b) ? (a) : (b))
#endif


/* Try to establish endianness - supports BSD, GNU and SysV style */

#ifdef BYTE_ORDER	/* BSD */
#ifdef BIG_ENDIAN
#if BYTE_ORDER == BIG_ENDIAN
#define ISBIGENDIAN	1
#endif
#endif
#else	/* not BSD */

#ifdef __BYTE_ORDER	/* GNU */
#ifdef __BIG_ENDIAN
#if __BYTE_ORDER == __BIG_ENDIAN
#define ISBIGENDIAN	1
#endif
#endif
#else	/* not GNU */

#ifndef __386__		/* Some systems define this */

#ifdef _BIG_ENDIAN	/* Generic _BIG_ENDIAN */
#define ISBIGENDIAN	1
#else
#ifndef _LITTLE_ENDIAN
#error Cannot determine endianness! Please add a test for your system to common/misc.h
#endif
#endif

#endif	/* QNX4 */
#endif  /* GNU */
#endif  /* BSD */


/* Macro to convert from/to 32-bit values in network order */

#ifdef ISBIGENDIAN
#define netint32(n)	((U_INT32_T)(n))
#else
#define netint32(n)	((((U_INT32_T)(n) & (U_INT32_T)0x000000ffUL) << 24) |  \
			 (((U_INT32_T)(n) & (U_INT32_T)0x0000ff00UL) << 8)  |  \
			 (((U_INT32_T)(n) & (U_INT32_T)0x00ff0000UL) >> 8)  |  \
			 (((U_INT32_T)(n) & (U_INT32_T)0xff000000UL) >> 24))
#endif

/* Macro to return (at least) the page size */

#ifdef HAVE_GETPAGESIZE
#include <unistd.h>
#define GETPAGESIZE	((size_t)getpagesize())
#else
#define GETPAGESIZE	((size_t)8192)	    /* should work on most platforms */
#endif


/*
 * PROTOTYPES
 */

void *safe_malloc(size_t n);
int safe_read(int fd, void *p, size_t l);

void hex(char *buf, const char *src, ssize_t len);
void get_random_data(char *p, ssize_t len);

#endif

