/*
 * MYTYPES - Common set of types and associated macros 
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2004/05/11 - Split off from metadata.h
 */


#ifndef __MYTYPES_H
#define __MYTYPES_H 1


/*
 * INCLUDES & DEFINES
 */


#include <sys/types.h>	/* For ssize_t */
#include <limits.h>	/* For XXX_MAX */

#define ORD_MAX		ULONG_MAX
#define NAME_LEN	128


/* 
 * TYPES
 */


typedef char NAME[NAME_LEN];	/* ASCIIZ, often accompanied by a length var */

typedef unsigned long ORD;	/* largest comfortable data type for host CPU 
				   to work with; must be able to hold pointer.
				   int is already defined by C as most comfort-
				   able host type, so we use that as-is. */

#endif
