#include <unistd.h>	/* open, close */
#include <fcntl.h>	/* O_RDONLY */
#include <string.h>	/* memchr */
#include <stdio.h>	/* printf */
#include <stdlib.h>	/* malloc */
#include <errno.h>

#include <metadict.h>
#include <debug.h>


int main()
{
    META *m;
    META_SPC *s;
    META_VND *v;
    META_ITEM *i;

    msg_setthresh(F_DICT, L_DEBUG);
    printf("\ndictionary test\n");

    m = meta_newfromdict("raddb"); 
    if (!m) { msg(F_DICT, L_ERR, "Could not process dictionary!\n"); _exit(1); }
 
    v = meta_getvndbynr(m, 307);
    if (!v) printf("No vendor 307\n");
    else printf("307=%.*s\n", v->namel, v->name);
    for(s = m->spaces; s; s = s->next) {
	for(i = s->items; i; i = i->next) {
/*	    if (i->vnd != 307) continue; */
	    printf("  %ld/%ld/%ld=%.*s:%.*s\n", s->nr, i->vnd, i->nr, 
		   s->namel, s->name, i->namel, i->name);
	}
    }

    meta_del(m);

    return 0;
}

