#include <unistd.h>	/* open, close */
#include <fcntl.h>	/* O_RDONLY */
#include <string.h>	/* memchr */
#include <stdio.h>	/* printf */
#include <stdlib.h>	/* MALLOC */
#include <errno.h>

#include <fastring.h>
#include <misc.h>	/* for STR, mem(c)spn */


typedef struct stream {
    RING *r;
    int fd, eof, aux;		/* line counter or other state info */
} STRM;


STRM *strm_new(int fd, ssize_t bufsize)
{
    STRM *ret;
 
    ret = (STRM *)malloc(sizeof(STRM)); if (!ret) return 0;
    memset(ret, 0, sizeof(STRM));
    ret->r = ring_new(bufsize); if (!ret->r) { free(ret); return 0; }
    ret->fd = fd;

    return ret;
}


void strm_del(STRM *strm)
{
    ring_del(strm->r);
    free(strm);
}


STR strm_getline(STRM *strm)
{
    ssize_t max, len, rd, rl;
    char *end, *rp;
    
    for(;;) {
	max = ring_maxget(strm->r);
	end = memchr(strm->r->r, '\n', max);
	if (end) { rl = end - strm->r->r + 1; break; }
	if (strm->eof) { rl = max; break; }
        rd = ring_maxput(strm->r); 
	if (!rd) { rl = max; break; }	   /* line cut in two */
	len = safe_read(strm->fd, strm->r->w, rd);
	ring_put(strm->r, len);
	if (!len) strm->eof++;
    }
    strm->aux++;
    rp = strm->r->r; 
    ring_get(strm->r, rl);
    return (STR){rp, rl};
}


int main()
{
    RING *r;
    STRM *strm;
    STR str, w;
    int fd;

    printf("\nfastring test\n");

    r = ring_new(128); if (r == 0) return 1;

    ring_put(r, 5);
    printf("r=%ld, w=%ld, maxget=%ld, maxput=%ld\n", (long)(r->r - r->mp.p), (long)(r->w - r->mp.p), (long)ring_maxget(r), (long)ring_maxput(r));

    ring_put(r, ring_maxput(r));
    printf("r=%ld, w=%ld, maxget=%ld, maxput=%ld\n", (long)(r->r - r->mp.p), (long)(r->w - r->mp.p), (long)ring_maxget(r), (long)ring_maxput(r));

    ring_get(r, 8);
    printf("r=%ld, w=%ld, maxget=%ld, maxput=%ld\n", (long)(r->r - r->mp.p), (long)(r->w - r->mp.p), (long)ring_maxget(r), (long)ring_maxput(r));

    ring_get(r, ring_maxget(r));
    printf("r=%ld, w=%ld, maxget=%ld, maxput=%ld\n", (long)(r->r - r->mp.p), (long)(r->w - r->mp.p), (long)ring_maxget(r), (long)ring_maxput(r));

    ring_del(r);

    /* stream test */

    printf("\nstream rest\n");

    fd = open("ringtest2.file", O_RDONLY); if (fd == -1) { perror("open ringtest2.file"); return 1; }

    strm = strm_new(fd, 128); if (!strm) { fprintf(stderr, "Could not create stream!\n"); return 1; }

    /* make sure we wrap around */ 
    ring_put(strm->r, ring_capacity(strm->r) - 15);	
    ring_get(strm->r, ring_maxget(strm->r));

    while(str = strm_getline(strm), str.l) {
	printf("\n%04d: ", strm->aux);
	while(w = str_getword(&str, "\r\n\t ", 4), w.l) {
	   printf("[%.*s] ", w.l, w.p);
	}
    }
    printf("\n\n");

    strm_del(strm);
    close(fd);

    return 0;
}

