/*
 * DEBUG - Debugging and logging functions
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2000/12/02 - EvB - Created
 * 2001/10/29 - EvB - Redone, it was just too damn ugly.
 */


/*
 * INCLUDES & DEFINES
 */


/* Debugging levels. These should match syslog's. I'm not including
   syslog.h here because it depends on HAVE_SYSLOG whether that's possible,
   and I don't want to pass that macro to all files that include this one.
   Come back when I just pass the compatibility flags to everything. */

#define L_ERR		3
#define L_NOTICE	5
#define L_DEBUG		7


/* Level up to which debugging macros are active */

#ifndef DEBUGLEVEL
#define DEBUGLEVEL	3
#endif

#ifndef DBG_CVTBUFLEN
#define DBG_CVTBUFLEN	512
#endif


/* The internal message facilities */

#define F_MISC			0	/* miscellaneous */
#define F_TEXT			1	/* textfile handling (dictionary) */
#define F_LANG			2	/* language */
#define F_PROC			3	/* subprocesses events */
#define F_RECV			4	/* packet reception */
#define F_SEND			5	/* packet sending */

#define F_CNT			6
#define F_INVAL			F_CNT	/* use to test getfacbyname against */


/* Macros for conditional compiling of debugging statements */

#define D1(x)			/* (was: x) */
#define D2(x)			/* (was: x) */
#define D3(x)			/* (was: x) */

#if DEBUGLEVEL >= 1
#undef D1
#define D1(x)			x
#if DEBUGLEVEL >= 2
#undef D2
#define D2(x)			x
#if DEBUGLEVEL >= 3
#undef D3
#define D3(x)			x
#endif
#endif
#endif


/*
 * GLOBAL VARIABLES
 */


extern int msg_nostderr;	/* Be quiet on stderr */
extern int msg_syslogfac;	/* Syslog facility to which we output all */
extern int msg_thresh[F_CNT];	/* Priority threshold */

/*
 * PROTOTYPES
 */


/* Event logging interface */

void msg_init(int syslogfac, int nostderr);
void msg_setthresh(int ourfac, int level);
void msg_settag(char *tag, int tagl);

int msg_getfacbyname(char *name);
int msg_getsyslogfacbyname(char *name);

void msg(int ourfac, int level, char *fmt, ...);
void msg_line(int level, char *logline);


/* Convert a lstring to a printable asciiz string. */

char *dbg_cvtstr(char *s, int slen);


/* Quick and dirty hexdump to stderr. */

void hexdump(char *s, int slen);

