# Note: this design uses target-specific flags, because it's the only
# way to get the value of a variable that's different for each
# subdirectory, $(d), into the build recipes. Once you go that way,
# you can as well use the feature to specify (extra) objects and 
# libraries to be linked or archived.


# Standard stuff

VERSION		:= pre0.9.13-$$(date +%y%m%d)

.SUFFIXES:
.SUFFIXES:	.c .o

all:		targets


# Subdirectories, in random order

dir	:= server
include		$(dir)/Rules.mk
dir	:= language
include		$(dir)/Rules.mk
dir 	:= common
include		$(dir)/Rules.mk
dir	:= modules
include		$(dir)/Rules.mk
dir	:= tools
include		$(dir)/Rules.mk
dir	:= etc
include		$(dir)/Rules.mk


# General directory independent rules

%.i:		%.c
		$(PREP)

%.o:		%.c
		$(COMP)

%:		%.o
		$(LINK)

%:		%.c
		$(COMPLINK)


# These two targets collect real targets, i.e. ones that can be built.

.PHONY:		targets
targets:	$(TGT_BIN) $(TGT_SBIN) $(TGT_ETC) $(TGT_LIB)

.PHONY:		testprogs
testprogs:	$(TGT_TEST)


# These targets merely contain commands to be executed, i.e. they collect
# only .PHONY targets, even if they're not explicitly marked as such. 
# The install target does not collect dependencies (other than for forcing
# things to be built) because it's always considered 'out of date' anway as
# it's a .PHONY target. Instead, it collects installation commands that will be
# ran in addition to the standard ones to install the known targets.

.PHONY:		clean
clean:
		rm -f $(CLEAN)

.PHONY:		install
install:	targets 
		$(INST) $(TGT_BIN) -m 755 -d $(INST_PREFIX)$(DIR_BIN)
		$(CMD_INSTBIN)
		$(INST) $(TGT_SBIN) -m 755 -d $(INST_PREFIX)$(DIR_SBIN)
		$(CMD_INSTSBIN)
		$(INST) $(TGT_LIB) -m 755 -d $(INST_PREFIX)$(DIR_LIB)
		$(CMD_INSTLIB)
ifeq ($(wildcard $(INST_PREFIX)$(DIR_ETC)/*),)
		$(INST) $(TGT_ETC) -m 644 -d $(INST_PREFIX)$(DIR_ETC)
		$(CMD_INSTETC)
else
		@echo
		@echo Configuration directory $(DIR_ETC) already present -- skipping. 
		@echo
		@echo When upgrading, is recommended to rename your existing configuration
		@echo directory $(DIR_ETC) to eg. $(DIR_ETC).orig,
		@echo to redo the installation, and to copy only the configuration- and behaviour 
		@echo files and the files in the legacy and modules subdirectories that have 
		@echo local changes back from the .orig directory.
endif
		@echo
		@echo If no error messages appeared, OpenRADIUS is now installed successfully. 
		@echo
		@echo It is strongly recommended to add a user and group for the RADIUS server,
		@echo and to use the supervise, setuidgid and multilog programs from daemontools.
		@echo After creating the group, run the following command as root, where
		@echo radiusgroup is the name of the new group:
		@echo
		@echo '	#' chgrp -R radiusgroup $(DIR_ETC)
		@echo
		@echo To test the server, make sure you are a member of the group mentioned above,
		@echo and then run the server as the current user in foreground mode, by typing:
		@echo
		@echo '	$$' $(DIR_SBIN)/radiusd -dsend -b
		@echo
		@echo You can then send a test request from another terminal, by typing:
		@echo
		@echo '	$$' $(DIR_BIN)/radtest -v evbergen welcome1 localhost h1dd3n
		@echo

.PHONY:		dist
dist:		clean
		@d=`basename $$(pwd)` ; \
		 n=openradius-$(VERSION) ; \
		 mv ../$$d ../$$n ; \
		 tar -C .. -czf ../$$n.tar.gz $$n --exclude .svn ; \
		 mv ../$$n ../$$d ; \
		 echo Created $$n.tar.gz

.PHONY:		bla
bla:		
		@echo Version: $(VERSION)


# Prevent make from removing any build targets, including intermediate ones

.SECONDARY:	$(CLEAN)

