/*
 * MISC - Miscellaneous utility functions
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/06/25 - EvB - Moved hex and memrchr here from lang_vm.c
 * 2001/10/29 - EvB - Moved netint32 here from channels.c so we can also
 * 		      use it in meta_ops.c
 * 2002/02/23 - EvB - Added encrypt_attr_pap 
 * 2005/06/01 - EvB - Added hmac_md5, moved get_random_data here from radclient
 * 2005/12/09 - EvB - Ported to evblib
 */


#ifndef __MISC_H
#define __MISC_H	1


 /*
  * INCLUDES & DEFINES
  */


#include <evblib/misc/misc.h>		
#include <evblib/str/str.h>		

#include <metadata.h>		/* for META_ORD */


/* Legacy macro */

#define netint32(n)	net32(n)


/*
 * PROTOTYPES
 */

void hmac_md5(char *out, char *in, META_ORD inl, char *key, META_ORD keyl);

void encrypt_attr_pap(char *src, META_ORD srclen,
		      char *dst, META_ORD *dstlen,
		      char *sec, META_ORD seclen,
		      char *auth, META_ORD authlen);
void decrypt_attr_pap(char *src, META_ORD srclen,
		      char *dst, META_ORD *dstlen,
		      char *sec, META_ORD seclen,
		      char *auth, META_ORD authlen);

void encrypt_attr_style_1(char *text, META_ORD *len,char *secret,char *reqauth);
int decrypt_attr_style_1(char *text, META_ORD *len, char *secret,char *reqauth);

#endif

