
# Fetch data attached to client. Done separately because we need it early.

function CLIENTLOOKUP (

  Sql(str = "select attribute, value from data where space=? and name=?",
      str = "str,IP-Source",		  # attrs bound to place holders
      str = "clients"), 
  delall str, del rep:int,
1),


# Fetch data attached to user. Done separately because EAP wants to do it
# again if it discovers an 'inner' username.

function USERLOOKUP (

  # Uncomment if you want per-realm values, incl. the local-realm and 
  # strip-realm options; the Target-Server attribute also generally
  # comes from here.
  #
  #str = "select attribute, value from data where space=? and name=?",
  #str = "str,str",
  #str = "realms",
  #str = (User-Name beforefirst "/" or User-Name afterlast "@"),
  #str and (
  #  Sql, 
  #  del rep:int,
  #  local-realm and User-Name := (User-Name afterfirst "/" or 
  #				   User-Name beforelast "@" or
  #				   User-Name)
  #),
  #delall str,

  # Uncomment if you want per-user values
  #
  Sql(str = "select attribute, value from data where space=? and name=?",
      str = "str,User-Name",
      str = "users"), 
  delall str, del rep:int,
1),


# Fetch data attached to other entities. Note: If you bind attributes other 
# than 'str', User-Name or IP-Source to placeholders (using the 'str' after
# the SQL query), you must add those to the sendattr list in the configuration
# file as well. The filtering is done for efficiency reasons.

function OTHERLOOKUP (

  # Uncomment if you want a global default set of values
  #
  #Sql(str = "select attribute, value from data where space=? and name=?",
  #    str = "str,str",
  #    str = "defaults",
  #    str = "defaults"), 
  #delall str, del rep:int,

  # Uncomment if you want per-nas values
  #
  #Sql(str = "select attribute, value from data where space=? and name=?",
  #    str = "str,str",
  #    str = "nases",
  #    str = (NAS-Identifier or NAS-IP-Address)), 
  #delall str, del rep:int,
1),


# Perform logging

function LOG (

  # Uncomment if you want to log event to SQL too
  #Sql(str = "insert into log (log_when, log_who, log_what) " .
  #          "values (now(), ?, ?)",
  #    str = "User-Name,str",
  #    str = REP:Log-Line), delall str, del REP:int,
  #
  # Uncomment if you want to log to SQL only, not to stderr/file or syslog
  #del Log-Line,
1),


# vim:softtabstop=2:sw=2

