#include <stdio.h>	/* for fprintf() */
#include <errno.h>	/* for errno */
#include <string.h>	/* for strerror(), strtok() */
#include <stdlib.h>	/* for strtoul() */

#include <evblib/str/str.h>

#include <metadict.h>
#include <metaops.h>

#define DEBUGLEVEL 3
#include <debug.h>




int main()
{
	META *m;
	META_SPC *s;
	char *input;
	static char output[2048];
	META_ORD len;
	META_AV *avlist, *avdstlst, *av, *tail;
#if 0
	int n;
#endif

	msg_init(-1, 0);
	msg_setthresh(F_RECV, L_DEBUG);
	msg_setthresh(F_SEND, L_DEBUG);

	printf("\nREADING DICTIONARY\n");
	
	m = meta_newfromdict("../../etc");	/* Use as base path */
	if (!m) {
		fprintf(stderr, "metatest: ERROR: could not create meta object "
				"from dictionary!\n");
		return 1;
	}

#if 0
	printf("\nSPACES\n");
	for(spc = m->spaces; spc; spc = spc->next) {
		s = spc;
		printf("Space %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
		s = meta_getspcbyname(m, spc->name, spc->namel);
		printf("    N %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
		s = meta_getspcbynr(m, spc->nr);
		printf("    O %p: nr=%ld, atr_ofs=%d, atr_size=%d, vnd_ofs=%d, vnd_size=%d, enc_item=%p, name=%s\n",
		       s, s->nr, s->atr_ofs, s->atr_size, s->vnd_ofs, s->vnd_size, s->enc_item, s->name);
	}

	printf("\nVENDORS\n\n");
	for(v = m->vendors; v; v = v->next) {
		printf("Vendor %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
		v = meta_getvndbyname(m, vnd->name, vnd->namel);
		printf("     N %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
		v = meta_getvndbynr(m, vnd->nr);
		printf("     O %p: nr=%ld, name=%s\n",
		       v, v->nr, v->name);
	}

	printf("\nDATA ITEMS\n");
	for(s = m->spaces; s; s = s->next) {

		for(i = s->items; i; i = i->next) {

			printf(" Item %p: spc=%p, vnd=%ld, nr=%ld, len_ofs=%d, len_size=%d, len_adj=%d, val_ofs=%d, val_size=%d, val_type=%d, subspace=%p, name=%s\n", i, i->spc, i->vnd, i->nr, i->len_ofs, i->len_size, i->len_adj, i->val_ofs, i->val_size, i->val_type, i->subspace, i->name);
		}
	}
#endif

	printf("\nDECODING TEST\n");
	input = "\x01\xaa\x00\x61"
		"ABCDEFGHIJKLMNOP"
		"\x06\x06\x00\x00\x00\x02"
		"\x07\x06\x00\x00\x00\x02"
		"\x20\x09TestNas"
		"\x01\x08Myself"
		"\x04\x06\xc0\xa8\x05\xfe"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 1"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 2"
		"\x05\x06\x00\x00\x00\x05"
		"\x02\x08s3cret";
	/*
	input =
	"\x01\xbe\x00\x65\x1c\x48\x6b\x68\x23\xce\x43\x6a\x0f\xe9\x79\x47"
	"\x6e\x1f\xce\x47\x01\x07\x63\x6c\x73\x69\x6c\x02\x12\x50\xa7\x46"
	"\xbb\xb3\x8b\x15\x22\x78\x9e\x58\xf4\xe2\x97\xbe\x8f\x05\x06\x00"
	"\x00\x00\x01\x1a\x0c\x00\x00\x01\x33\x02\x06\x74\x65\x73\x74\x1a"
	"\x0c\x00\x00\x01\x33\x03\x06\x54\x69\x4e\x43\x1a\x0e\x00\x00\x01"
	"\xad\x00\x00\x98\x23\x74\x65\x73\x74\x04\x06\xc2\x98\xa6\x7d\x21"
	"\x06\x61\x35\x62\x65";
	*/

	s = meta_getspcbyname(m, "UDP-PKT", 7);
	if (!s) { 
		msg(F_MISC, L_ERR, "main: ERROR: Space 'UDP-PKT' not found!\n");
		return 1;
	}

	avlist = meta_decode(m, s, 0, input, 0x65, &tail, 0);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding data!\n");
		return 1;
	}
	/* Remove explicit length field */
	for(av = avlist; av; av = av->next) {
		if (av->i->spc->nr == 1 && av->i->nr == 2) av->flags |= AV_DEL;
	}
	meta_printavlist(m, avlist, 0);

#if 0
	/* Add an overlength item */
	av = (META_AV *)malloc(sizeof(META_AV));
	if (!av) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not alloc pair!\n");
		return 1;
	}
	memset(av, 0, sizeof(META_AV));
	av->i = meta_getitembyspec(m, pstr("EAP-Message"));
	av->l = 1024;
	av->p = (char *)av->i;
	meta_addav(&avlist, &tail, 0, 0, av);
#endif

	printf("\nBUILDTREE TEST\n");

	meta_buildtree(avlist, &avdstlst, s);
	meta_printavlist(m, avdstlst, 0);

	printf("\nENCODING TEST\n");

	memset(output, 0, sizeof(output));
	len = meta_encode(s, output, sizeof(output), avdstlst, 0);
	if (len == -1) {
		msg(F_MISC, L_ERR, "main: ERROR: error encoding data!\n");
		return 1;
	}
	printf("Hexdump of %ld (0x%lx) bytes:\n", len, len);
	hexdump(output, len);
	meta_freeavlist(avlist); avlist = 0;
	meta_freeavtree(avdstlst); avdstlst = 0;

	printf("\nDECODING AGAIN\n");
	avlist = meta_decode(m, s, 0, output, len, 0, 0);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding just encoded "
				   "data!\n");
		return 1;
	}
	meta_printavlist(m, avlist, 0);
	meta_freeavlist(avlist);

	meta_del(m);
	return 0;
}

