
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <textfile.h>
#include <debug.h>


int main()
{
	TEXT *t;
	static char line[LINE_MAX + 1];
	char *s;
	int len, n;

	msg_init(-1, 0);
	msg_setthresh(F_TEXT, L_NOTICE);

	/* Go relative from cwd */
	t = text_new("", (LINE_MAX << 1) + 2);
	if (!t) {
		perror("text_new"); return 2; 
	}

#if 0
	if (text_include(t, "texttest1.file") == -1) {
		perror("text_include"); return 3;
	}

	n = 0;
	while((len = text_getline(t, line, 15)) >= 0) {

		n++;
		printf("%06d (%03d): %s\n", n, len, line);
	}
	if (len == TEXT_IOERR) {
		perror("text_getline");
		return 4;
	}

	text_endfile(t);

/******/
	printf("\r\n");


	if (text_include(t, "texttest2.file") == -1) {
		perror("text_include"); return 3;
	}

	n = 0;
	while((len = text_getword(t, line, 9)) >= 0) {

		n++;
		printf("%06d (%03d): %s\n", n, len, line);
	}
	if (len == TEXT_IOERR) {
		perror("text_getword");
		return 4;
	}

	text_endfile(t);

/******/
	printf("\r\n");

	if (text_include(t, "texttest3.file") == -1) {
		perror("text_include"); return 3;
	}

	n = 0;
	/* First, get non-empty lines - #'s end a line prematurely.  */
	while((len = text_strtok3(t, line, sizeof(line), 
/*				  "\r\n", "\r\n#", "\r\n")) >= 0) { */
				  "$", "$#", "$")) >= 0) { 

		if (len) {
			n++;
			printf("%06d (%03d): %s\n", n, len, line); 
/*			s = strtok(line, " \t");
			while(s) {
				printf("%s+", s);
				s = strtok(0, " \t");
			}
			printf("\n\n"); */
		}
	}

	if (len == TEXT_IOERR) {
		perror("text_getword");
		return 4;
	}

	text_endfile(t);

/******/
	printf("\r\n");
#endif

	if (text_include(t, "texttest3.file") == -1) {
		perror("text_include"); return 3;
	}

	/* Get parsed items. Escape = \, both quotes = ', comment start = #,
	   comment end = eol, item end and start character = $ */
	n = text_linenr(t);
	while((len = text_getparseditem(t, line, sizeof(line), 
					'\\', '\'', '\'',
					'#', TEXT_META_EOL, 
					'$', '$')) >= 0) { 
		printf("%06d (%03d): %s\n", n, len, line); 
		n = text_linenr(t);
	}

	if (len == -1 && text_status(t) != RING_EOF) {
		perror("text_getparseditem");
		return 4;
	}

	text_endfile(t);

/******/
	printf("\r\n");

	if (text_include(t, "texttest3.file") == -1) {
		perror("text_include"); return 3;
	}

	/* Get parsed items. Escape = \, both quotes = ', comment start = #,
	   comment end = eol, item end and start character = $ */
	n = text_linenr(t);
	while((len = text_getparseditem(t, line, sizeof(line), 
					'\\', '\'', '\'',
					'#', TEXT_META_EOL, 
					'$', '$')) >= 0) { 
		s = strtok(line, " \t\n\r"); 
		if (s) {
			printf("%06d (%03d): ", n, len);
			while(s) {
				printf("%s ", s);
				s = strtok(0, " \t\n\r");
			}
			printf("\n");
		}
		n = text_linenr(t);
	}

	if (len == -1 && text_status(t) != RING_EOF) {
		perror("text_getparseditem");
		return 4;
	}

	text_del(t);

	return 0;
}
