/*
 * Copyright (c) 1997-1999  The Stanford SRP Authentication Project
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following conditions apply:
 *
 * 1. Any software that incorporates the SRP authentication technology
 *    must display the following acknowlegment:
 *    "This product uses the 'Secure Remote Password' cryptographic
 *     authentication system developed by Tom Wu (tjw@CS.Stanford.EDU)."
 *
 * 2. Any software that incorporates all or part of the SRP distribution
 *    itself must also display the following acknowledgment:
 *    "This product includes software developed by Tom Wu and Eugene
 *     Jhong for the SRP Distribution (http://srp.stanford.edu/srp/)."
 *
 * 3. Redistributions in source or binary form must retain an intact copy
 *    of this copyright notice and list of conditions.
 */

#include <stdio.h>
#include "t_defines.h"
#include "t_pwd.h"
#include "t_sha.h"

#ifdef NO_ERRNO
int errno = -1;
#else
extern int errno;
#endif

main(argc, argv)
     int argc;
     char **argv;
{
  struct t_conf * tc;
  struct t_confent * tce;
  struct t_pw * tpw;
  struct t_pwent * ent;
  int i;
  unsigned char dout[SHA_DIGESTSIZE];
  SHA1_CTX ctxt;
  BigInteger N, g, xs, xp;
  char hexbuf[MAXHEXPARAMLEN];
  char username[16];
  char pass[128];

  t_random(hexbuf, 64);
  printf("Strong random numbers:\n");
  for(i = 0; i < 64; ++i)
    printf("%02X ", (unsigned char) hexbuf[i]);

  printf("\n\nSHA-1 Test Vector (expected output):\n");
  printf("A9 99 3E 36 47 06 81 6A BA 3E 25 71 78 50 C2 6C 9C D0 D8 9D\n");
  SHA1Init(&ctxt);
  SHA1Update(&ctxt, "abc", 3);
  SHA1Final(dout, &ctxt);
  printf("SHA-1('abc'):\n");
  for(i = 0; i < 20; ++i)
    printf("%02X ", (unsigned char) dout[i]);
  SHA1Init(&ctxt);
  SHA1Update(&ctxt, "a", 1);
  SHA1Update(&ctxt, "b", 1);
  SHA1Update(&ctxt, "c", 1);
  SHA1Final(dout, &ctxt);
  printf("\nSHA-1('a'||'b'||'c'):\n");
  for(i = 0; i < 20; ++i)
    printf("%02X ", (unsigned char) dout[i]);

  printf("\n");

  if(argc > 1) {
    tpw = t_openpw(NULL);
    if(tpw == NULL) {
      fprintf(stderr, "t_openpw failed, errno=%d\n", errno);
      exit(1);
    }

    printf("Getting password entry for %s...\n", argv[1]);
    ent = t_getpwbyname(tpw, argv[1]);
    if(ent == NULL)
      printf("%s not found\n", argv[1]);
    else {
      printf("%s's public password (length %d) = ", argv[1], ent->password.len);
      for(i = 0; i < ent->password.len; ++i) {
	printf("%.2X ", ent->password.data[i]);
      }
      printf("\nIndex = %d\n", ent->index);
      tc = t_openconf(NULL);
      if(tc == NULL) {
	fprintf(stderr, "t_openconf failed, errno=%d\n", errno);
	exit(1);
      }
      tce = t_getconfbyindex(tc, ent->index);
      if(tce == NULL)
	printf("Index %d not found!\n", ent->index);
      else {
	printf("Modulus length = %d, modulus = ", tce->modulus.len);
	for(i = 0; i < tce->modulus.len; ++i) {
	  printf("%.2X ", tce->modulus.data[i]);
	}
	printf("\nGenerator length = %d, generator = ", tce->generator.len);
	for(i = 0; i < tce->generator.len; ++i) {
	  printf("%.2X ", tce->generator.data[i]);
	}
	printf("\n");
      }
#ifndef WIN32
      t_getpass(pass, 128, "Enter a password:");
      SHA1Init(&ctxt);
      SHA1Update(&ctxt, ent->name, strlen(ent->name));
      SHA1Update(&ctxt, ":", 1);
      SHA1Update(&ctxt, pass, strlen(pass));
      SHA1Final(dout, &ctxt);
      printf("Password hash = ");
      for(i = 0; i < sizeof(dout); ++i)
	printf("%.2X ", dout[i]);
      printf("\n");

      N = BigIntegerFromBytes(tce->modulus.data, tce->modulus.len);
      g = BigIntegerFromBytes(tce->generator.data, tce->generator.len);
      xs = BigIntegerFromBytes(dout, sizeof(dout));
      xp = BigIntegerFromInt(0);
      BigIntegerModExp(xp, g, xs, N);
      BigIntegerToHex(xp, hexbuf);
#endif

      BigIntegerFree(xp);
      BigIntegerFree(xs);
      BigIntegerFree(g);
      BigIntegerFree(N);

      t_closeconf(tc);

      printf("Public password: %s\n", hexbuf);
    }
    t_closepw(tpw);
  }
  else
    while(printf("login: "), (gets(username) != NULL && *username != '\0'))
    {
      t_getpass(pass, 128, "Enter a password:");
      if(t_verifypw(username, pass) > 0)
	printf("Login accepted\n");
      else
	printf("Login incorrect\n");
    }
  return 0;
}

