dnl -*- mode: m4; comment-start: "%" -*-
include(`macros.m4')divert(-1)
% $Id: des.m4,v 1.12 1999/02/14 02:19:14 geoffk Exp $

define(v_KS,0x80)		The key schedule
define(v_block,0xE0)		The block to encrypt
define(v_preP,0xE0)		The data fed into the P permutation
define(v_xkey,0xE0)		The current expanded key word
define(v_pblock,0xE8)		The block after IP/before FP
define(v_L,0xE8)		The left half of the block
define(v_R,0xEC)		The right half of the block
define(v_count,0xF0)		The round number
define(v_scount,0xF1)		The s-box being processed
define(v_sndx,0xF2)		The index of the s-box being processed
define(v_sched_copy_src,0xF3)	Index variables for the scheduler
define(v_sched_copy_dst,0xF4)
define(test_ram,0xF5)		Workspace for the test program (5 bytes)

define(NUMROUNDS,16)

divert`'dnl
ip_bit:	bytes(3,7,2,6,1,5,0,4)
	
des_ip:	lda	#7
	sta	v_count
ip_loop:
forloop(`i',0,7,`dnl
	rol	v_block+i
	rora
')dnl
	ldx	v_count
	ldx	ip_bit,X
	sta	v_pblock,X
	dec	v_count
	bpl	ip_loop
	rts

des_fp:	lda	#7
	sta	v_count
fp_loop:
	ldx	v_count
	ldx	ip_bit,X
	lda	v_pblock,X
forloop(`i',0,7,`dnl
	rora
	rol	v_block+i
')dnl
	dec	v_count
	bpl	fp_loop
	rts

des_sboxes:
include(des-sboxes.s)

des_4cycle:
	bytes(v_R+3,v_R+0,v_R+1,v_R+2,v_R+3,v_R+0)
des_3cycle:
	bytes(0,1,2,0)

%  The encrypt/decrypt entry point.
%  Put the input block in v_block, call des_ip, call des, call des_fp,
%  and find the output block in v_block again.
%  The scheduled key is stored in v_KS.  Each block of 6 bytes in v_KS
%  represents a 48-bit K_n in FIPS 46-2 with bits permuted to match the
%  code below
dnl ...by the following:
define(`des_key_schp',`
 0, 1, 2, 3, 4, 5,31,30,
12,13,14,15,16,17,33,32,
24,25,26,27,28,29,35,34,
36,37,38,39,40,41,43,42,
 6, 7, 8, 9,10,11,45,44,
18,19,20,21,22,23,47,46')dnl
des:
	clr	v_count
des_loop:

	ldx	v_count
	clr	v_xkey+6
forloop(`i',0,5,`dnl
	lda	v_KS+i,X
	lsra
	rol	v_xkey+eval(i/3+6)
	lsra
	rol	v_xkey+eval(i/3+6)
	sta	v_xkey+i
')dnl

	clr	v_scount
	clr	v_sndx
des_s_loop:
	ldx	v_scount
	lda	v_R,X
	ldx	des_4cycle,X
	ldx	,X
	lsrx
	rora
	lsra
	lsra
	ldx	v_scount
	eor	v_xkey,X
	add	v_sndx
	tax
	lda	des_sboxes,X
	and	#0xF0
	ldx	v_scount
	sta	v_preP,X

	lda	v_R,X
	ldx	des_4cycle+2,X
	ldx	,X
	lslx
	rola
	ldx	v_scount
	eor	v_xkey+4,X
	and	#0x3F
	add	v_sndx
	tax
	lda	des_sboxes,X
	and	#0x0F
	ldx	v_scount
	ora	v_preP,X
	sta	v_preP,X

	inc	v_scount
	lda	v_sndx
	add	#0x40
	sta	v_sndx
	bne	des_s_loop

% Some somewhat complicated P-executing code...

define(p_table,`
16,  7, 20, 21,
29, 12, 28, 17,
 1, 15, 23, 26,
 5, 18, 31, 10,
 2,  8, 24, 14,
32, 27,  3,  9,
19, 13, 30,  6,
22, 11,  4, 25')dnl
permute_and_eor(v_L,v_preP,quote(foreach_c(`t',`p_table',`eval(t-1)')))dnl

% Perhaps we don't need to switch because it's the last round.
	lda	v_count
	add	#0x6
	sta	v_count
	cmp	#0x6*NUMROUNDS
	beq	des_done

% switch L and R
forloop(`i',0,3,`dnl
	ldx	v_L+i
	lda	v_R+i
	sta	v_L+i
	stx	v_R+i
')dnl
% and do the next round.
	jmp	des_loop
des_done:
	rts

pc1_bit:
	bytes(4,5,6,7,2,1,0)

% Input: The key (64 bits with parity in low bits of bytes)
% in v_block.
% Output: The key scheduled into v_KS.
des_schedule:
	
% first do PC-1, which is just IP slightly modified:
% C (in v_L):
% 57   49   41   33   25   17    9    1
% 58   50   42   34   26   18   10    2    
% 59   51   43   35   27   19   11    3   
% 60   52   44   36    -    -    -    -
% D (in v_R):
% 63   55   47   39   31   23   15    7   
% 62   54   46   38   30   22   14    6   
% 61   53   45   37   29   21   13    5   
% 28   20   12    4    -    -    -    -
	
	lda	#6
	sta	v_count
pc1_loop:
forloop(`i',0,7,`dnl
	rol	v_block+i
	rora
')dnl
	ldx	v_count
	ldx	pc1_bit,X
	sta	v_pblock,X
	dec	v_count
	bpl	pc1_loop
	lda	v_pblock+7
	and	#0xF0
	sta	v_pblock+3
	lsl	v_pblock+7
	lsl	v_pblock+7
	lsl	v_pblock+7
	lsl	v_pblock+7

	clr	v_count
	lda	#0b00111111
	sta	v_scount
	lda	#0b01111110
	sta	v_scount+1
des_sched_loop:
% First, the shift(s)
	ldx	#1

shiftloop:
define(rotl3_5,`dnl
	lda	3+$1
	lsla
	rol	2+$1
	rol	1+$1
	rol	$1
	adc	#0xF
	and	#0xF0
	sta	3+$1
')dnl
	rotl3_5(v_L)
	rotl3_5(v_R)

	decx
	bne	done_shifts
	lsl	v_scount+1
	rol	v_scount
	bcs	shiftloop
done_shifts:

% Next, do PC-2 (yuk!) and get the bits in the right order for `des'.
define(pc2_table,`
14, 17, 11, 24,  1,  5,
 3, 28, 15,  6, 21, 10,
23, 19, 12,  4, 26,  8,
16,  7, 27, 20, 13,  2,
41, 52, 31, 37, 47, 55,
30, 40, 51, 45, 33, 48,
44, 49, 39, 56, 34, 53,
46, 42, 50, 36, 29, 32')dnl
permute_and_store(v_xkey,v_pblock,dnl
quote(foreach_c(`t',`des_key_schp',dnl
`eval(choosei(t,`pc2_table')-1+ifelse(eval(t>=24),1,4,0))')))dnl

% and now copy it into the key schedule
	lda	#5
	sta	v_sched_copy_src
	add	v_count
	add	#v_KS
	sta	v_sched_copy_dst
sched_copy_loop:
	ldx	v_sched_copy_src
	lda	v_xkey,X
	ldx	v_sched_copy_dst
	sta	,X
	dec	v_sched_copy_dst
	dec	v_sched_copy_src
	bpl	sched_copy_loop

% finish the loop, do the next key word
	lda	v_count
	add	#6
	sta	v_count
	cmp	#NUMROUNDS*6
	beq	des_sched_done
	jmp	des_sched_loop
des_sched_done:
	rts

test_program(test_ram,v_block,8,v_block,v_block,8,dnl
jsr des_schedule,jsr des_ip
	jsr des
	jsr des_fp)dnl

include(`des-test.m4')
